/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.RandomAccessIF;
import ca.nanometrics.io.ThreadedMultiMappedFile;
import java.io.EOFException;
import java.io.IOException;

public class Segment
implements RandomAccessIF {
    protected ThreadedMultiMappedFile m_file;
    private long m_address;
    private long m_size;
    private long m_pointer;
    private int m_segmentId;
    private boolean m_usable = true;

    public Segment(ThreadedMultiMappedFile file, long segmentFileOffset, int segmentSize, int segmentId) {
        this.m_file = file;
        this.setAddress(segmentFileOffset);
        this.setSize(segmentSize);
        this.setPointer(0L);
        this.setSegmentId(segmentId);
    }

    boolean isValidOffset(long offset) {
        return offset >= 0L && offset < this.getSize();
    }

    private void checkValidOffset(long position) throws IOException {
        if (!this.isValidOffset(position)) {
            throw new IOException("Position " + position + " is outside of segment.");
        }
    }

    private void canWriteAtOffset(long offset) throws EOFException {
        if (!this.isValidOffset(offset)) {
            throw new EOFException("Address " + offset + " is outside of segment.");
        }
    }

    private void canWrite(int len) throws EOFException {
        this.canWriteAtOffset(this.getPointer() + (long)len - 1L);
    }

    public void close() throws IOException {
        this.m_file.close();
    }

    public synchronized void flush() throws IOException {
        this.m_file.flush();
    }

    public long getPointer() {
        return this.m_pointer;
    }

    public long getSize() {
        return this.m_size;
    }

    public void seek(long position) throws IOException {
        this.checkValidOffset(position);
        this.setPointer(position);
    }

    public void setLength(long length) throws IOException {
        if (length > this.m_file.getSize()) {
            throw new IOException("Length " + length + " is too large.");
        }
        this.m_size = length;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.canWrite(len);
        long address = this.getAddress() + this.getPointer();
        int i = this.m_file.read(address, b, off, len);
        this.incrementPointer(i);
        return i;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        this.canWrite(len);
        long address = this.getAddress() + this.getPointer();
        this.m_file.write(address, buf, offset, len);
        this.incrementPointer(len);
    }

    public synchronized void write(byte[] buf) throws IOException {
        this.canWrite(buf.length);
        long address = this.getAddress() + this.getPointer();
        this.m_file.write(address, buf);
        this.incrementPointer(buf.length);
    }

    public synchronized void write(int value) throws IOException {
        this.writeByte(value);
    }

    public synchronized void writeBoolean(boolean value) throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeBoolean(address, value);
        this.incrementPointer(1L);
    }

    public synchronized void writeByte(int value) throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeByte(address, value);
        this.incrementPointer(1L);
    }

    public synchronized void writeBytes(String value) throws IOException {
        this.canWrite(value.length());
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeBytes(address, value);
        this.incrementPointer(value.length());
    }

    public synchronized void writeChar(int value) throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeChar(address, value);
        this.incrementPointer(2L);
    }

    public synchronized void writeChars(String value) throws IOException {
        this.canWrite(value.length() * 2);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeChars(address, value);
        this.incrementPointer(value.length() * 2);
    }

    public synchronized void writeDouble(double value) throws IOException {
        this.canWrite(8);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeDouble(address, value);
        this.incrementPointer(8L);
    }

    public synchronized void writeFloat(float value) throws IOException {
        this.canWrite(4);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeFloat(address, value);
        this.incrementPointer(4L);
    }

    public synchronized void writeInt(int value) throws IOException {
        this.canWrite(4);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeInt(address, value);
        this.incrementPointer(4L);
    }

    public synchronized void writeLong(long value) throws IOException {
        this.canWrite(8);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeLong(address, value);
        this.incrementPointer(8L);
    }

    public synchronized void writeShort(int value) throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeShort(address, value);
        this.incrementPointer(2L);
    }

    public synchronized void writeUTF(String value) throws IOException {
        this.canWrite(value.length() + 2);
        long address = this.getAddress() + this.getPointer();
        this.m_file.writeUTF(address, value);
        this.incrementPointer(value.length() + 2);
    }

    public synchronized boolean readBoolean() throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        boolean result = this.m_file.readBoolean(address);
        this.incrementPointer(1L);
        return result;
    }

    public synchronized byte readByte() throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        byte result = this.m_file.readByte(address);
        this.incrementPointer(1L);
        return result;
    }

    public synchronized char readChar() throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        char result = this.m_file.readChar(address);
        this.incrementPointer(2L);
        return result;
    }

    public synchronized double readDouble() throws IOException {
        this.canWrite(8);
        long address = this.getAddress() + this.getPointer();
        double result = this.m_file.readDouble(address);
        this.incrementPointer(8L);
        return result;
    }

    public synchronized float readFloat() throws IOException {
        this.canWrite(4);
        long address = this.getAddress() + this.getPointer();
        float result = this.m_file.readFloat(address);
        this.incrementPointer(4L);
        return result;
    }

    public synchronized void readFully(byte[] buf, int offset, int len) throws IOException {
        this.canWrite(len);
        long address = this.getAddress() + this.getPointer();
        this.m_file.readFully(address, buf, offset, len);
        this.incrementPointer(len);
    }

    public synchronized void readFully(byte[] buf) throws IOException {
        this.canWrite(buf.length);
        long address = this.getAddress() + this.getPointer();
        this.m_file.readFully(address, buf);
        this.incrementPointer(buf.length);
    }

    public synchronized int readInt() throws IOException {
        this.canWrite(4);
        long address = this.getAddress() + this.getPointer();
        int result = this.m_file.readInt(address);
        this.incrementPointer(4L);
        return result;
    }

    public synchronized String readLine() throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        String result = this.m_file.readLine(address);
        this.incrementPointer(result.length());
        return result;
    }

    public synchronized long readLong() throws IOException {
        this.canWrite(8);
        long address = this.getAddress() + this.getPointer();
        long result = this.m_file.readLong(address);
        this.incrementPointer(8L);
        return result;
    }

    public synchronized short readShort() throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        short result = this.m_file.readShort(address);
        this.incrementPointer(2L);
        return result;
    }

    public synchronized int readUnsignedByte() throws IOException {
        this.canWrite(1);
        long address = this.getAddress() + this.getPointer();
        int result = this.m_file.readUnsignedByte(address);
        this.incrementPointer(1L);
        return result;
    }

    public synchronized int readUnsignedShort() throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        int result = this.m_file.readUnsignedShort(address);
        this.incrementPointer(2L);
        return result;
    }

    public synchronized String readUTF() throws IOException {
        this.canWrite(2);
        long address = this.getAddress() + this.getPointer();
        String result = this.m_file.readUTF(address);
        this.incrementPointer(result.length() + 2);
        return result;
    }

    public synchronized int skipBytes(int numBytes) throws IOException {
        if (numBytes <= 0) {
            return 0;
        }
        if (!this.isValidOffset(this.m_pointer + (long)numBytes)) {
            this.m_pointer = this.m_size - 1L;
            throw new EOFException();
        }
        this.m_pointer += (long)numBytes;
        return numBytes;
    }

    private void setPointer(long curPointer) {
        this.m_pointer = curPointer;
    }

    private void incrementPointer(long inc) {
        this.m_pointer += inc;
    }

    public long getAddress() {
        return this.m_address;
    }

    protected void setAddress(long segmentFileOffset) {
        this.m_address = segmentFileOffset;
    }

    public int getSegmentId() {
        return this.m_segmentId;
    }

    protected void setSegmentId(int id) {
        this.m_segmentId = id;
    }

    void setUsable(boolean b) {
        this.m_usable = b;
    }

    boolean isUsable() {
        return this.m_usable;
    }

    protected void setSize(long segmentSize) {
        this.m_size = segmentSize;
    }

    public String toString() {
        return "Segment #" + this.getSegmentId() + " " + this.getSize() + "bytes @" + this.getAddress();
    }
}

