/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.Header;
import ca.nanometrics.io.Segment;
import ca.nanometrics.io.ThreadedMultiMappedFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SegmentAllocator {
    private static final String START_ID = "ALOC";
    private static final String FREE_SEGMENT_ID = "FREE";
    private static final int HEADER_SIZE = 12;
    private ThreadedMultiMappedFile m_file;
    private int m_numAllocatedSegments = 0;
    private int m_numUsableSegments = -1;
    private int m_numFreeSegments = -1;
    private int m_segmentSize = 0;
    private AllocationEntry[] m_entries;
    private Segment[] m_segments;

    public SegmentAllocator(ThreadedMultiMappedFile file, int segmentSize) throws IOException {
        this.setFile(file);
        try {
            this.read();
            this.initCachedSegments();
        }
        catch (IOException e) {
            this.setSegmentSize(segmentSize);
            this.setEntriesSize(this.getNumUsableSegments());
            this.setNumFreeSegments(this.getNumUsableSegments());
            this.initCachedSegments();
            this.flush();
        }
    }

    public void close() throws IOException {
        this.write();
    }

    public Segment allocate() throws IOException {
        AllocationEntry entry = this.createNextUnusedEntry();
        if (entry == null) {
            return null;
        }
        return this.allocateSegment(entry);
    }

    private Segment allocate(int segmentId) throws IOException {
        AllocationEntry entry = this.getEntry(segmentId);
        if (entry == null) {
            entry = this.createAndAddEntry(segmentId);
        }
        return this.allocateSegment(entry);
    }

    private Segment allocateSegment(AllocationEntry entry) throws IOException {
        Segment segment = new Segment(this.getFile(), entry.getAddress(), this.getSegmentSize(), entry.getSegmentId());
        this.decrementFreeSegments();
        this.addCachedSegment(segment);
        this.writeHeader();
        this.writeEntry(segment.getSegmentId());
        return segment;
    }

    public Segment getFirstSegment() throws IOException {
        Segment firstSegment = this.getSegment(0);
        if (firstSegment != null && firstSegment.getSegmentId() != 0) {
            throw new IOException("Retrieval of First Segment returned Segment #" + firstSegment.getSegmentId());
        }
        if (firstSegment == null && ((firstSegment = this.allocate()) == null || firstSegment.getSegmentId() != 0)) {
            if (firstSegment != null) {
                this.freeSegment(firstSegment);
            }
            if ((firstSegment = this.recoverFirstSegment()) == null || firstSegment.getSegmentId() != 0) {
                throw new IOException("First Allocation did not return First Segment! (Returned #" + (firstSegment == null ? "null" : String.valueOf(firstSegment.getSegmentId())) + " SegmentSize=" + this.getSegmentSize() + ")");
            }
        }
        return firstSegment;
    }

    private Segment recoverFirstSegment() throws IOException {
        int firstSegmentAddress = this.getFirstSegmentAddress();
        AllocationEntry entry = new AllocationEntry(true, firstSegmentAddress, this.getSegmentSize());
        Segment segment = new Segment(this.getFile(), entry.getAddress(), this.getSegmentSize(), entry.getSegmentId());
        entry.setUsed(true);
        entry.setSegmentId(firstSegmentAddress);
        this.addEntry(entry);
        this.addCachedSegment(segment);
        return segment;
    }

    public Segment getSegment(int segmentId) {
        Segment segment = this.getCachedSegment(segmentId);
        if (segment != null) {
            return segment;
        }
        AllocationEntry entry = this.getEntry(segmentId);
        if (entry != null && entry.isUsed()) {
            segment = new Segment(this.getFile(), entry.getAddress(), entry.getSegmentSize(), segmentId);
            this.addCachedSegment(segment);
        }
        return segment;
    }

    public Segment getSegmentForcibly(int segmentId) throws IOException {
        Segment segment = this.getSegment(segmentId);
        if (segment != null) {
            return segment;
        }
        AllocationEntry entry = this.getEntry(segmentId);
        if (entry == null) {
            this.allocate(segmentId);
        } else {
            entry.isUsed();
        }
        if (entry != null && entry.isUsed()) {
            segment = new Segment(this.getFile(), entry.getAddress(), entry.getSegmentSize(), segmentId);
            this.addCachedSegment(segment);
        }
        return segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeSegment(Segment segment) throws IOException {
        if (segment == null) {
            return;
        }
        Segment segment2 = segment;
        synchronized (segment2) {
            segment.seek(0L);
            segment.write(FREE_SEGMENT_ID.getBytes("UTF-8"));
            segment.setUsable(false);
            int segmentId = segment.getSegmentId();
            AllocationEntry entry = this.getEntry(segmentId);
            if (entry != null) {
                if (entry.isUsed()) {
                    this.incrementFreeSegments();
                    entry.setUsed(false);
                    this.writeHeader();
                    this.writeEntry(segment.getSegmentId());
                }
                this.freeCachedSegment(segmentId);
            }
        }
    }

    private boolean willFit(int segmentSize) {
        return (long)segmentSize < this.getFile().getSize() - (long)(this.getSegmentSize() * this.getNumAllocatedSegments());
    }

    private AllocationEntry createNextUnusedEntry() throws IOException {
        if (this.getNumAllocatedSegments() < this.getNumUsableSegments() && this.willFit(this.getSegmentSize())) {
            int nextSegmentId = this.getNumAllocatedSegments();
            AllocationEntry entry = this.createAndAddEntry(nextSegmentId);
            return entry;
        }
        List entriesList = this.getEntriesList();
        if (entriesList != null) {
            Iterator it = entriesList.iterator();
            while (it.hasNext()) {
                AllocationEntry entry = (AllocationEntry)it.next();
                if (entry == null || entry.isUsed()) continue;
                entry.setUsed(true);
                return entry;
            }
        }
        return null;
    }

    private int getSegmentAddress(int segmentId) {
        return segmentId * this.getSegmentSize() + this.getFirstSegmentAddress();
    }

    public int getNumSegments() {
        return this.getNumUsableSegments();
    }

    public int getNumFreeSegments() {
        return this.m_numFreeSegments;
    }

    protected void decrementFreeSegments() {
        --this.m_numFreeSegments;
    }

    protected void incrementFreeSegments() {
        ++this.m_numFreeSegments;
    }

    protected void setNumFreeSegments(int numSegments) {
        this.m_numFreeSegments = numSegments;
    }

    protected int getNumUsableSegments() {
        if (this.m_numUsableSegments <= 0) {
            int entriesPerFirstTable;
            int numUsable = this.getNumTotalSegments() - 1;
            if (numUsable <= (entriesPerFirstTable = (this.getSegmentSize() - SegmentAllocator.getHeaderSize()) / 13)) {
                this.m_numUsableSegments = numUsable;
            } else {
                int entriesPerTable = this.getSegmentSize() / 13;
                int numTotal = this.getNumTotalSegments();
                numUsable = numTotal * entriesPerTable / (1 + entriesPerTable);
                int numTables = numTotal - numUsable;
                if ((numUsable = entriesPerFirstTable + (numTables - 1) * entriesPerTable) + numTables > numTotal) {
                    numUsable -= numUsable + numTables - numTotal;
                }
                this.m_numUsableSegments = numUsable < 0 ? 0 : numUsable;
            }
        }
        return this.m_numUsableSegments;
    }

    protected int getNumTotalSegments() {
        if (this.getSegmentSize() <= 0) {
            return 0;
        }
        return (int)(this.getFile().getSize() / (long)this.getSegmentSize());
    }

    protected int getNumTableSegments() {
        return this.getNumTotalSegments() - this.getNumUsableSegments();
    }

    protected int getFirstSegmentAddress() {
        return this.getNumTableSegments() * this.getSegmentSize();
    }

    public void flush() throws IOException {
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        ThreadedMultiMappedFile file;
        this.writeHeader();
        ThreadedMultiMappedFile threadedMultiMappedFile = file = this.getFile();
        synchronized (threadedMultiMappedFile) {
            AllocationEntry[] entries = this.getEntries();
            if (entries != null) {
                int i = 0;
                while (i < this.getNumAllocatedSegments()) {
                    if (entries[i] == null) {
                        throw new IOException("SegmentAllocator has " + this.getNumAllocatedSegments() + " allocated segments, but entry #" + i + " is null!");
                    }
                    entries[i].write(file);
                    ++i;
                }
            }
            file.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader() throws IOException, UnsupportedEncodingException {
        ThreadedMultiMappedFile file;
        ThreadedMultiMappedFile threadedMultiMappedFile = file = this.getFile();
        synchronized (threadedMultiMappedFile) {
            file.write(0L, START_ID.getBytes("UTF-8"));
            file.writeInt(4L, this.getNumAllocatedSegments());
            file.writeInt(8L, this.getSegmentSize());
            file.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntry(int segmentId) throws IOException {
        ThreadedMultiMappedFile file;
        ThreadedMultiMappedFile threadedMultiMappedFile = file = this.getFile();
        synchronized (threadedMultiMappedFile) {
            this.getEntry(segmentId).write(file, this.getEntryAddress(segmentId));
            file.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        ThreadedMultiMappedFile file;
        ThreadedMultiMappedFile threadedMultiMappedFile = file = this.getFile();
        synchronized (threadedMultiMappedFile) {
            byte[] readBytes = new byte[START_ID.length()];
            file.readFully(0L, readBytes);
            String readStartId = Header.makeString(readBytes);
            if (!readStartId.equals(START_ID)) {
                throw new IOException("No SegmentAllocator found in file.");
            }
            int numAllocatedEntries = file.readInt(file.getPointer());
            this.setSegmentSize(file.readInt(file.getPointer()));
            this.setEntriesSize(this.getNumUsableSegments());
            this.setNumFreeSegments(this.getNumUsableSegments());
            int i = 0;
            while (i < numAllocatedEntries) {
                AllocationEntry entry = new AllocationEntry(i, file);
                if (entry.isUsed()) {
                    this.decrementFreeSegments();
                }
                this.addEntry(entry);
                ++i;
            }
        }
    }

    private long getEntryAddress(int segmentId) {
        return 12 + segmentId * 13;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SegmentAllocator)) {
            return false;
        }
        SegmentAllocator sat = (SegmentAllocator)o;
        if (sat.getEntries().length != this.getEntries().length) {
            return false;
        }
        if (sat.getNumAllocatedSegments() != this.getNumAllocatedSegments() || sat.getSegmentSize() != this.getSegmentSize()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumAllocatedSegments()) {
            if (!this.getEntry(i).equals(sat.getEntry(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "Segment size:" + this.getSegmentSize() + " Allocated:" + this.getNumAllocatedSegments() + " Free: " + this.getNumFreeSegments() + " Total: " + this.getNumUsableSegments();
    }

    public List getEntriesList() {
        if (this.getEntries() == null || this.getEntries().length == 0) {
            return null;
        }
        return Arrays.asList(this.getEntries());
    }

    protected AllocationEntry[] getEntries() {
        return this.m_entries;
    }

    protected AllocationEntry getEntry(int segmentId) {
        if (this.m_entries == null || segmentId > this.getNumSegments()) {
            return null;
        }
        return this.m_entries[segmentId];
    }

    protected void setEntriesSize(int size) {
        this.m_entries = new AllocationEntry[size];
    }

    private void setEntry(int segmentId, AllocationEntry entry) {
        if (entry != null) {
            this.m_entries[segmentId] = entry;
        }
    }

    private AllocationEntry createAndAddEntry(int segmentId) throws IOException {
        AllocationEntry entry = new AllocationEntry(true, this.getSegmentAddress(segmentId), this.getSegmentSize());
        entry.setSegmentId(segmentId);
        this.addEntry(entry);
        return entry;
    }

    protected void addEntry(AllocationEntry entry) throws IOException {
        int id;
        if (this.getEntries() == null) {
            this.setEntriesSize(this.getNumUsableSegments());
        }
        if ((id = entry.getSegmentId()) > this.getEntries().length) {
            throw new IOException("AllocationEntry Index " + id + " is out of bounds.");
        }
        this.setEntry(id, entry);
        this.incrementNumAllocatedSegments();
    }

    protected int getNumAllocatedSegments() {
        return this.m_numAllocatedSegments;
    }

    protected void incrementNumAllocatedSegments() {
        ++this.m_numAllocatedSegments;
    }

    protected void setNumAllocatedSegments(int numSegments) {
        this.m_numAllocatedSegments = numSegments;
    }

    public int getSegmentSize() {
        return this.m_segmentSize;
    }

    protected void setSegmentSize(int segmentSize) {
        this.m_segmentSize = segmentSize < 0 ? 0 : segmentSize;
    }

    private void initCachedSegments() {
        this.m_segments = new Segment[this.getNumUsableSegments()];
    }

    private Segment getCachedSegment(int segmentId) {
        if (this.m_segments != null && segmentId < this.m_segments.length) {
            return this.m_segments[segmentId];
        }
        return null;
    }

    private void addCachedSegment(Segment segment) {
        int segmentId = segment.getSegmentId();
        if (this.m_segments != null && segmentId < this.m_segments.length) {
            this.m_segments[segmentId] = segment;
        }
    }

    private void freeCachedSegment(int segmentId) {
        if (this.m_segments != null && segmentId < this.m_segments.length) {
            this.m_segments[segmentId] = null;
        }
    }

    protected void setFile(ThreadedMultiMappedFile m_file) {
        this.m_file = m_file;
    }

    public ThreadedMultiMappedFile getFile() {
        return this.m_file;
    }

    public static int getHeaderSize() {
        return 12;
    }

    public class AllocationEntry {
        public static final int ENTRY_SIZE = 13;
        private boolean m_used = false;
        private long m_address = 0L;
        private int m_segmentSize = 0;
        private int m_segmentId;

        public AllocationEntry(boolean used, long address, int segmentSize) {
            this.setUsed(used);
            this.setAddress(address);
            this.setSegmentSize(segmentSize);
        }

        public AllocationEntry(int id, ThreadedMultiMappedFile file) throws IOException {
            this(id, file, file.getPointer());
        }

        public AllocationEntry(int id, ThreadedMultiMappedFile file, long address) throws IOException {
            this.setSegmentId(id);
            this.setUsed(file.readBoolean(address));
            this.setAddress(file.readLong(address + 1L));
            this.setSegmentSize(file.readInt(address + 9L));
        }

        public boolean isUsed() {
            return this.m_used;
        }

        public long getAddress() {
            return this.m_address;
        }

        void write(ThreadedMultiMappedFile file) throws IOException {
            file.writeBoolean(file.getPointer(), this.m_used);
            file.writeLong(file.getPointer(), this.m_address);
            file.writeInt(file.getPointer(), this.m_segmentSize);
        }

        void write(ThreadedMultiMappedFile file, long address) throws IOException {
            file.writeBoolean(address, this.m_used);
            file.writeLong(address + 1L, this.m_address);
            file.writeInt(address + 9L, this.m_segmentSize);
        }

        public boolean equals(Object o) {
            if (!(o instanceof AllocationEntry)) {
                return false;
            }
            AllocationEntry entry = (AllocationEntry)o;
            return entry.getAddress() == this.getAddress() && entry.isUsed() == this.isUsed();
        }

        public String toString() {
            return "#" + this.getSegmentId() + " @" + this.getAddress() + " " + this.isUsed();
        }

        public int getSegmentId() {
            return this.m_segmentId;
        }

        protected void setSegmentId(int id) {
            this.m_segmentId = id;
        }

        public int getSegmentSize() {
            return this.m_segmentSize;
        }

        protected void setSegmentSize(int segmentSize) {
            this.m_segmentSize = segmentSize;
        }

        protected void setAddress(long address) {
            this.m_address = address;
        }

        protected void setUsed(boolean used) {
            this.m_used = used;
        }
    }
}

