/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.MultiMappedFile;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ThreadedMultiMappedFile {
    private MultiMappedFile m_file;

    public ThreadedMultiMappedFile(String dir, long multiFileSize, long volumeSize, int writeBufferSize, int readBufferSize) throws IOException {
        this.m_file = new MultiMappedFile(dir, multiFileSize, volumeSize, writeBufferSize, readBufferSize);
    }

    public ThreadedMultiMappedFile(long multiFileSize, long volumeSize) throws IOException {
        this("./", multiFileSize, volumeSize);
    }

    public ThreadedMultiMappedFile(String dir, long multiFileSize, long volumeSize) throws IOException {
        this(dir, multiFileSize, volumeSize, 16384, 131072);
    }

    public ThreadedMultiMappedFile(String[] files, int writeBufferSize, int readBufferSize) throws FileNotFoundException, IOException {
        this.m_file = new MultiMappedFile(files, writeBufferSize, readBufferSize);
    }

    public ThreadedMultiMappedFile(String[] files) throws FileNotFoundException, IOException {
        this(files, 16384, 131072);
    }

    public synchronized boolean isComplete() {
        return this.m_file.isComplete();
    }

    public synchronized void close() throws IOException {
        this.m_file.close();
    }

    public synchronized void delete() throws IOException {
        this.m_file.delete();
    }

    public synchronized void flush() throws IOException {
        this.m_file.flush();
    }

    public synchronized long getPointer() {
        return this.m_file.getPointer();
    }

    public synchronized long getSize() {
        return this.m_file.getSize();
    }

    public synchronized void setLength(long length) throws IOException {
        this.m_file.setLength(length);
    }

    private void seek(long position) throws IOException {
        this.m_file.seek(position);
    }

    public synchronized int read(long address, byte[] b, int off, int len) throws IOException {
        this.seek(address);
        return this.m_file.read(b, off, len);
    }

    public synchronized void readFully(long address, byte[] b, int off, int len) throws IOException {
        this.seek(address);
        this.m_file.readFully(b, off, len);
    }

    public synchronized int read(long address) throws IOException {
        this.seek(address);
        return this.m_file.read();
    }

    public synchronized String readLine(long address) throws IOException {
        this.seek(address);
        return this.m_file.readLine();
    }

    public synchronized void readFully(long address, byte[] b) throws IOException {
        this.seek(address);
        this.m_file.readFully(b);
    }

    public synchronized boolean readBoolean(long address) throws IOException {
        this.seek(address);
        return this.m_file.readBoolean();
    }

    public synchronized byte readByte(long address) throws IOException {
        this.seek(address);
        return this.m_file.readByte();
    }

    public synchronized int readUnsignedByte(long address) throws IOException {
        this.seek(address);
        return this.m_file.readUnsignedByte();
    }

    public synchronized short readShort(long address) throws IOException {
        this.seek(address);
        return this.m_file.readShort();
    }

    public synchronized int readUnsignedShort(long address) throws IOException {
        this.seek(address);
        return this.m_file.readUnsignedShort();
    }

    public synchronized char readChar(long address) throws IOException {
        this.seek(address);
        return this.m_file.readChar();
    }

    public synchronized int readInt(long address) throws IOException {
        this.seek(address);
        return this.m_file.readInt();
    }

    public synchronized long readLong(long address) throws IOException {
        this.seek(address);
        return this.m_file.readLong();
    }

    public synchronized float readFloat(long address) throws IOException {
        this.seek(address);
        return this.m_file.readFloat();
    }

    public synchronized double readDouble(long address) throws IOException {
        this.seek(address);
        return this.m_file.readDouble();
    }

    public synchronized String readUTF(long address) throws IOException {
        this.seek(address);
        return this.m_file.readUTF();
    }

    public synchronized void write(long address, int b) throws IOException {
        this.seek(address);
        this.m_file.write(b);
    }

    public synchronized void write(long address, byte[] b) throws IOException {
        this.seek(address);
        this.m_file.write(b);
    }

    public synchronized void write(long address, byte[] b, int off, int len) throws IOException {
        this.seek(address);
        this.m_file.write(b, off, len);
    }

    public synchronized void writeBoolean(long address, boolean v) throws IOException {
        this.seek(address);
        this.m_file.writeBoolean(v);
    }

    public synchronized void writeByte(long address, int b) throws IOException {
        this.seek(address);
        this.m_file.writeByte(b);
    }

    public synchronized void writeShort(long address, int v) throws IOException {
        this.seek(address);
        this.m_file.writeShort(v);
    }

    public synchronized void writeChar(long address, int v) throws IOException {
        this.seek(address);
        this.m_file.writeChar(v);
    }

    public synchronized void writeInt(long address, int v) throws IOException {
        this.seek(address);
        this.m_file.writeInt(v);
    }

    public synchronized void writeLong(long address, long v) throws IOException {
        this.seek(address);
        this.m_file.writeLong(v);
    }

    public synchronized void writeFloat(long address, float v) throws IOException {
        this.seek(address);
        this.m_file.writeFloat(v);
    }

    public synchronized void writeDouble(long address, double v) throws IOException {
        this.seek(address);
        this.m_file.writeDouble(v);
    }

    public synchronized void writeBytes(long address, String str) throws IOException {
        this.seek(address);
        this.m_file.writeBytes(str);
    }

    public synchronized void writeChars(long address, String str) throws IOException {
        this.seek(address);
        this.m_file.writeChars(str);
    }

    public synchronized void writeUTF(long address, String str) throws IOException {
        this.seek(address);
        this.m_file.writeUTF(str);
    }

    public synchronized String[] getVolumeFileNames() {
        return this.m_file.getVolumeFileNames();
    }
}

