/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelCommand;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CalibrationCommand
extends ChannelCommand
implements Packable {
    public static final int MSG_TYPE = 140;
    public static final int FLOAT_SIZE = 4;
    private float frequency;
    private float amplitude;
    private float duration;

    public CalibrationCommand(int[] chnlKeys, String password, double freq, double ampl, double dur) {
        super(chnlKeys, password);
        this.frequency = (float)freq;
        this.amplitude = (float)ampl;
        this.duration = (float)dur;
    }

    public CalibrationCommand(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 140;
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4 + 4;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        BigEndian.writeFloat(buffer, offset += super.getDataLength(), this.frequency);
        BigEndian.writeFloat(buffer, offset += 4, this.amplitude);
        BigEndian.writeFloat(buffer, offset += 4, this.duration);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        if (buffer.length - (offset += super.getDataLength()) < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.frequency = BigEndian.readFloat(buffer, offset);
        this.amplitude = BigEndian.readFloat(buffer, offset += 4);
        this.duration = BigEndian.readFloat(buffer, offset += 4);
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getDuration() {
        return this.duration;
    }
}

