/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class DataAddRequest
extends ChannelRequest
implements Packable {
    public static final int MSG_TYPE = 120;
    private int maxDelay;
    private int outputType;
    private boolean wantsBuffers;

    public DataAddRequest(int[] chnlKeys, int maxDelay, int outputType, boolean wantsBuffers) {
        super(chnlKeys);
        this.maxDelay = maxDelay;
        this.outputType = outputType;
        this.wantsBuffers = wantsBuffers;
    }

    public DataAddRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 120;
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4 + 4;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        int doBuff = this.wantsBuffers ? 1 : 0;
        BigEndian.writeInt(buffer, offset += super.getDataLength(), this.maxDelay);
        BigEndian.writeInt(buffer, offset + 4, this.outputType);
        BigEndian.writeInt(buffer, offset + 8, doBuff);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        if (buffer.length - (offset += super.getDataLength()) < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(buffer, offset);
        this.outputType = BigEndian.readInt(buffer, offset + 4);
        this.wantsBuffers = 1 == BigEndian.readInt(buffer, offset + 8);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public boolean wantsBuffers() {
        return this.wantsBuffers;
    }
}

