/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public abstract class NmxpAddRequest
extends ChannelRequest
implements Packable {
    private int maxDelay;
    private boolean wantsBuffers;

    public NmxpAddRequest(int[] chnlKeys, int maxDelay, boolean wantsBuffers) {
        super(chnlKeys);
        this.maxDelay = maxDelay;
        this.wantsBuffers = wantsBuffers;
    }

    public NmxpAddRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        int doBuff = this.wantsBuffers ? 1 : 0;
        BigEndian.writeInt(buffer, offset += super.getDataLength(), this.maxDelay);
        BigEndian.writeInt(buffer, offset + 4, doBuff);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        if (buffer.length - (offset += super.getDataLength()) < 8) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(buffer, offset);
        this.wantsBuffers = 1 == BigEndian.readInt(buffer, offset + 4);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public boolean wantsBuffers() {
        return this.wantsBuffers;
    }
}

