/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelHeader
implements Packable {
    public static final int MSG_TYPE = 256;
    static final int NAME_LEN = 12;
    static final int INT_SIZE = 4;
    static final int MAX_LENGTH = 11;
    static final int MSG_LEN = 28;
    private int key;
    private String name;
    private String network;

    public ChannelHeader(int channelKey, String channelName, String netName) {
        this.key = channelKey;
        this.name = this.normalizeName(channelName);
        this.network = this.normalizeName(netName);
    }

    public ChannelHeader() {
        this(0, null, null);
    }

    public ChannelHeader(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    private String normalizeName(String input) {
        if (input == null) {
            input = "none";
        }
        if (input.length() > 11) {
            input = input.substring(0, 11);
        }
        return input;
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getChannelExt() {
        int lastdot = this.name.lastIndexOf(46);
        return lastdot < 0 ? "" : this.name.substring(lastdot + 1);
    }

    public String getStationName() {
        int lastdot = this.name.lastIndexOf(46);
        return lastdot < 0 ? this.name : this.name.substring(0, lastdot);
    }

    public String getNetwork() {
        return this.network;
    }

    public int getDataLength() {
        return 28;
    }

    public int getDataType() {
        return 256;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length >= 28 && offset + 28 <= buffer.length) {
            this.key = BigEndian.readInt(buffer, offset);
            this.name = BigEndian.readString(buffer, offset += 4, 12);
            this.network = BigEndian.readString(buffer, offset += 12, 12);
            offset += 12;
        } else {
            throw new InvalidInputException("readFrom: insufficient data");
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeString(buffer, offset += 4, this.name, 12);
        BigEndian.writeString(buffer, offset += 12, this.network, 12);
        offset += 12;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.name + " " + this.key + ")";
    }
}

