/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.ChannelKey;

public class KeySelector {
    public static final int ALL = -1;
    private int instSpec;
    private int typeSpec;
    private int chanSpec;

    public KeySelector(int instrument, int type, int channel) {
        this.instSpec = instrument;
        this.typeSpec = type;
        this.chanSpec = channel;
    }

    private boolean isMatching(int spec, int field) {
        return spec == -1 || field == spec;
    }

    public boolean isMatching(int key) {
        return this.isMatching(this.instSpec, ChannelKey.getIDOf(key)) && this.isMatching(this.typeSpec, ChannelKey.getTypeOf(key)) && this.isMatching(this.chanSpec, ChannelKey.getChannelOf(key));
    }

    public int[] getMatchingKeys(int[] keys) {
        if (keys == null) {
            return new int[0];
        }
        int keyCount = keys.length;
        int selected = 0;
        int[] selectedKeys = new int[keyCount];
        int ix = 0;
        while (ix < keyCount) {
            if (this.isMatching(keys[ix])) {
                selectedKeys[selected] = keys[ix];
                ++selected;
            }
            ++ix;
        }
        int[] matchingKeys = new int[selected];
        System.arraycopy(selectedKeys, 0, matchingKeys, 0, selected);
        return matchingKeys;
    }
}

