/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Iterator;
import java.util.TreeSet;

public class KeySet {
    static final int INT_SIZE = 4;
    static final int ENTRY_SIZE = 4;
    static final int MIN_REQUEST_SIZE = 4;
    private TreeSet set = new TreeSet();

    public KeySet() {
    }

    public KeySet(int[] keys) {
        this.add(keys);
    }

    public KeySet(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void add(int key) {
        this.set.add(new Integer(key));
    }

    public void add(int[] keys) {
        if (keys != null) {
            int numEntries = keys.length;
            int ix = 0;
            while (ix < numEntries) {
                this.add(keys[ix]);
                ++ix;
            }
        }
    }

    public int getDataLength() {
        return 4 + 4 * this.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4) throw new InvalidInputException("readFrom: insufficient data");
        int numChannels = BigEndian.readInt(buffer, offset);
        if (numChannels * 4 > length - 4) throw new InvalidInputException("readFrom: insufficient data");
        this.set = new TreeSet();
        offset += 4;
        int ix = 0;
        while (ix < numChannels) {
            this.add(BigEndian.readInt(buffer, offset));
            offset += 4;
            ++ix;
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.size());
        offset += 4;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Integer key = (Integer)iter.next();
            BigEndian.writeInt(buffer, offset, (int)key);
            offset += 4;
        }
    }

    public Iterator iterator() {
        return this.set.iterator();
    }

    public int size() {
        return this.set.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int[] toIntArray() {
        int arraySize = this.size();
        int[] array = new int[arraySize];
        Iterator iter = this.iterator();
        int ix = 0;
        while (ix < arraySize && iter.hasNext()) {
            array[ix] = (Integer)iter.next();
            ++ix;
        }
        return array;
    }
}

