/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.nda.KeySelector;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class PrecisListRequest
implements Packable {
    public static final int MSG_TYPE = 203;
    public static final int INT_SIZE = 4;
    public static final int MSG_LEN = 12;
    private int instSpec;
    private int typeSpec;
    private int chanSpec;

    public PrecisListRequest() {
    }

    public PrecisListRequest(int instrument, int type, int channel) {
        this.instSpec = instrument;
        this.typeSpec = type;
        this.chanSpec = channel;
    }

    public PrecisListRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return 12;
    }

    public int getDataType() {
        return 203;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 12 || offset + 12 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.instSpec = BigEndian.readInt(buffer, offset);
        this.typeSpec = BigEndian.readInt(buffer, offset += 4);
        this.chanSpec = BigEndian.readInt(buffer, offset += 4);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.instSpec);
        BigEndian.writeInt(buffer, offset += 4, this.typeSpec);
        BigEndian.writeInt(buffer, offset += 4, this.chanSpec);
    }

    public int[] getMatchingKeys(int[] keys) {
        KeySelector selector = new KeySelector(this.instSpec, this.typeSpec, this.chanSpec);
        return selector.getMatchingKeys(keys);
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " " + this.instSpec + ", " + this.typeSpec + ", " + this.chanSpec;
    }
}

