/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.nda.IntervalRequest;
import ca.nanometrics.nda.KeySet;
import ca.nanometrics.util.InvalidInputException;

public class SohRequest
extends IntervalRequest {
    public static final int MSG_TYPE = 228;
    private KeySet bundleSet = new KeySet();

    public SohRequest() {
        this(0, 0, 0, null);
    }

    public SohRequest(int channelKey, int startSec, int endSec, int[] types) {
        super(channelKey, startSec, endSec);
        this.bundleSet.add(types);
    }

    public SohRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return super.getDataLength() + this.bundleSet.getDataLength();
    }

    public int getDataType() {
        return 228;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.bundleSet.readFrom(buffer, offset += super.getDataLength(), length);
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        this.bundleSet.writeTo(buffer, offset += super.getDataLength());
    }

    public int[] getBundleTypes() {
        return this.bundleSet.toIntArray();
    }

    protected String toStringEx() {
        return ", " + this.bundleSet;
    }
}

