/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.RequestPending;
import ca.nanometrics.msg.TerminateMessage;
import ca.nanometrics.nda.ChannelHeader;
import ca.nanometrics.nda.ChannelInfoRequest;
import ca.nanometrics.nda.ChannelListRequest;
import ca.nanometrics.nda.ConnectRequest;
import ca.nanometrics.nda.DataRequest;
import ca.nanometrics.nda.DataSize;
import ca.nanometrics.nda.DataSizeRequest;
import ca.nanometrics.nda.EventRequest;
import ca.nanometrics.nda.NdaMessageDecoder;
import ca.nanometrics.nda.NmxDataSource;
import ca.nanometrics.nda.PacketConsumer;
import ca.nanometrics.nda.PrecisList;
import ca.nanometrics.nda.PrecisListRequest;
import ca.nanometrics.nda.ReadyMessage;
import ca.nanometrics.nda.ResponseFileMsg;
import ca.nanometrics.nda.SohRequest;
import ca.nanometrics.nda.TcpMsgLink;
import ca.nanometrics.nda.TimeSeriesRequest;
import ca.nanometrics.nda.TriggerRequest;
import ca.nanometrics.nda.Y5HeaderMsg;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.yfile.Y5Header;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class TcpDataSource
implements NmxDataSource {
    public static final int LIST_TIMEOUT_MS = 60000;
    public static final int protocolVersion = 0;
    private String host;
    private int port;
    private String username;
    private String password;
    private TcpMsgLink connection;
    private ChannelList channelList = null;
    private long channelListRxTime = 0L;

    public TcpDataSource(String dsHost, int dsPort, String dsUsername, String dsPassword) {
        this.host = dsHost;
        this.port = dsPort;
        this.password = dsPassword;
        this.username = dsUsername;
    }

    private boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    protected void waitForReady() throws IOException {
        while (true) {
            try {
                Packable pkt;
                do {
                    pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                } while (!(pkt instanceof ReadyMessage));
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    private void connect() throws IOException {
        if (!this.isConnected()) {
            Socket socket = new Socket(this.host, this.port);
            this.connection = new TcpMsgLink(socket, new NdaMessageDecoder(), 10000, 1);
            this.connection.setReadTimeout(100);
            this.connection.write(new ConnectRequest(this.username, this.password, 0, this.connection.getConnectTime()));
            this.connection.flush();
            this.waitForReady();
        }
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeConnection() {
        try {
            try {
                this.connection.close();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.connection = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.connection = null;
            return;
        }
    }

    public void close() {
        if (this.isConnected()) {
            this.connection.send(new TerminateMessage(1));
        }
        this.closeConnection();
    }

    private void ping() {
        try {
            this.connection.write(new RequestPending());
            this.connection.flush();
            this.waitForReady();
        }
        catch (IOException ioe) {
            this.closeConnection();
        }
    }

    protected void sendRequest(Packable request) throws IOException {
        if (this.connection != null) {
            this.ping();
        }
        this.connect();
        this.connection.write(request);
        this.connection.flush();
    }

    protected void checkForTerminate(Packable pkt) throws IOException {
        if (pkt instanceof TerminateMessage) {
            this.closeConnection();
            String msg = ((TerminateMessage)pkt).getTermMessage();
            throw new IOException("connection closed by server: " + msg);
        }
    }

    public void cancel() {
    }

    protected void updateChannelList() throws IOException {
        this.sendRequest(new ChannelListRequest());
        while (true) {
            try {
                while (true) {
                    Packable pkt;
                    if ((pkt = this.connection.read()) instanceof ReadyMessage) {
                        return;
                    }
                    if (!(pkt instanceof ChannelList)) continue;
                    this.channelList = (ChannelList)pkt;
                    this.channelListRxTime = System.currentTimeMillis();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public ChannelList getChannelList() throws IOException {
        long now = System.currentTimeMillis();
        if (now / 60000L != this.channelListRxTime / 60000L) {
            this.updateChannelList();
        }
        return this.channelList;
    }

    public PrecisList getPrecisList(int instrument, int type, int channel) throws IOException {
        this.sendRequest(new PrecisListRequest(instrument, type, channel));
        PrecisList list = null;
        while (true) {
            try {
                while (true) {
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        if (list == null) {
                            list = new PrecisList();
                        }
                        return list;
                    }
                    if (!(pkt instanceof PrecisList)) continue;
                    list = (PrecisList)pkt;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public PrecisList getPrecisList() throws IOException {
        return this.getPrecisList(-1, -1, -1);
    }

    public PrecisList getPrecisList(int key) throws IOException {
        return this.getPrecisList(ChannelKey.getIDOf(key), ChannelKey.getTypeOf(key), ChannelKey.getChannelOf(key));
    }

    public ChannelHeader getChannelHeader(int key) throws IOException {
        this.sendRequest(new ChannelInfoRequest(key, 0));
        ChannelHeader header = null;
        while (true) {
            try {
                while (true) {
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        return header;
                    }
                    if (!(pkt instanceof ChannelHeader)) continue;
                    header = (ChannelHeader)pkt;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public Y5Header getY5Header(int key) throws IOException {
        this.sendRequest(new ChannelInfoRequest(key, 1));
        Y5Header header = null;
        while (true) {
            try {
                while (true) {
                    Y5HeaderMsg msg;
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        return header;
                    }
                    if (!(pkt instanceof Y5HeaderMsg) || (msg = (Y5HeaderMsg)pkt).getKey() != key) continue;
                    header = msg.getY5Header();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public InputStream getResponseFile(int key) throws IOException {
        this.sendRequest(new ChannelInfoRequest(key, 2));
        InputStream response = null;
        while (true) {
            try {
                while (true) {
                    ResponseFileMsg msg;
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        return response;
                    }
                    if (!(pkt instanceof ResponseFileMsg) || (msg = (ResponseFileMsg)pkt).getKey() != key) continue;
                    response = msg.getResponseStream();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public DataSize getDataSize(int key, int startSec, int endSec) throws IOException {
        this.sendRequest(new DataSizeRequest(key, startSec, endSec));
        DataSize response = null;
        while (true) {
            try {
                while (true) {
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        if (response == null) {
                            response = new DataSize(key, 1, 0);
                        }
                        return response;
                    }
                    if (!(pkt instanceof DataSize)) continue;
                    response = (DataSize)pkt;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    protected void getData(Packable request, PacketConsumer consumer) throws IOException {
        if (consumer == null) {
            return;
        }
        this.sendRequest(request);
        while (true) {
            try {
                while (true) {
                    Packable pkt = this.connection.read();
                    this.checkForTerminate(pkt);
                    if (pkt instanceof ReadyMessage) {
                        return;
                    }
                    consumer.processPacket(pkt);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public void getData(int key, int startSec, int endSec, PacketConsumer consumer) throws IOException {
        this.getData(new DataRequest(key, startSec, endSec), consumer);
    }

    public void getSoh(int key, int startSec, int endSec, int[] types, PacketConsumer consumer) throws IOException {
        this.getData(new SohRequest(key, startSec, endSec, types), consumer);
    }

    public void getTimeSeries(int key, int startSec, int endSec, int sampleRate, PacketConsumer consumer) throws IOException {
        this.getData(new TimeSeriesRequest(key, startSec, endSec, sampleRate), consumer);
    }

    public void getTriggers(int key, int startSec, int endSec, PacketConsumer consumer) throws IOException {
        this.getData(new TriggerRequest(key, startSec, endSec), consumer);
    }

    public void getEvents(int startSec, int endSec, double amplitude, PacketConsumer consumer) throws IOException {
        this.getData(new EventRequest(startSec, endSec, amplitude), consumer);
    }
}

