/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.io.ThreadedOutputStream;
import ca.nanometrics.msg.DefaultMessageDecoder;
import ca.nanometrics.msg.MessageDecoder;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.Packable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class TcpMsgLink {
    private static final int READ_SIG = 0;
    private static final int READ_TYPE = 1;
    private static final int READ_LENGTH = 2;
    private static final int READ_DATA = 3;
    private static final int READ_COMPLETE = 4;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int NMX_SIGNATURE = 2059197967;
    public static final int READ_CONNECT_TIME = 1;
    public static final int WRITE_CONNECT_TIME = 2;
    private Socket socket;
    private boolean closed = false;
    private OutputStream out;
    private DataInputStream in;
    private int readTimeout = 0;
    private int readState = 0;
    private int bytesRead = 0;
    private int rcvSig = 0;
    private int rcvType = 0;
    private int rcvLength = 0;
    private byte[] rcvData;
    private int connectTime = 0;
    private InternetPacketWrapper pktWrapper;
    private MessageDecoder decoder;
    private Packable cachedRequest = null;

    public TcpMsgLink(Socket sock, MessageDecoder messageDecoder, int timeout, int connectAction) throws IOException {
        this.socket = sock;
        this.out = new BufferedOutputStream(new ThreadedOutputStream(this.socket.getOutputStream(), timeout));
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 1024));
        this.pktWrapper = new InternetPacketWrapper();
        this.setDecoder(messageDecoder);
        this.socket.setSoLinger(true, 1);
        this.setReadTimeout(timeout);
        this.connectTime = (int)(System.currentTimeMillis() / 1000L);
        if (connectAction == 1) {
            this.connectTime = this.in.readInt();
        } else if (connectAction == 2) {
            this.writeInt(this.connectTime);
        }
    }

    private void writeInt(int value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(value);
        this.out.write(bos.toByteArray());
        this.out.flush();
    }

    public void setDecoder(MessageDecoder messageDecoder) {
        this.decoder = messageDecoder != null ? messageDecoder : new DefaultMessageDecoder();
    }

    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getConnectTime() {
        return this.connectTime;
    }

    public String toString() {
        String addressString = this.getAddress().getHostAddress();
        return String.valueOf(addressString) + ":" + this.getPort();
    }

    public void setReadTimeout(int millis) throws SocketException {
        this.readTimeout = millis;
        this.socket.setSoTimeout(this.readTimeout);
    }

    public boolean isConnected() {
        try {
            this.socket.setSoTimeout(this.readTimeout);
            return true;
        }
        catch (Exception any) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPacketAvailable() throws IOException {
        if (this.cachedRequest == null) {
            try {
                try {
                    this.socket.setSoTimeout(1);
                    this.cachedRequest = this.readInput();
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.socket.setSoTimeout(this.readTimeout);
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            this.socket.setSoTimeout(this.readTimeout);
        }
        return this.cachedRequest != null;
    }

    public Packable read() throws IOException {
        if (this.cachedRequest != null) {
            Packable request = this.cachedRequest;
            this.cachedRequest = null;
            return request;
        }
        return this.readInput();
    }

    private Packable readInput() throws IOException {
        if (this.readState == 0) {
            this.rcvSig = this.in.readInt();
            if (this.rcvSig == 2059197967) {
                this.readState = 1;
            } else {
                throw new IOException("invalid packet signature");
            }
        }
        if (this.readState == 1) {
            this.rcvType = this.in.readInt();
            this.readState = 2;
        }
        if (this.readState == 2) {
            this.rcvLength = this.in.readInt();
            this.bytesRead = 0;
            if (this.rcvLength > 0) {
                this.rcvData = new byte[this.rcvLength];
                this.readState = 3;
            } else {
                this.readState = 4;
            }
        }
        if (this.readState == 3) {
            while (this.bytesRead < this.rcvLength) {
                this.bytesRead += this.in.read(this.rcvData, this.bytesRead, this.rcvLength - this.bytesRead);
            }
            if (this.bytesRead >= this.rcvLength) {
                this.readState = 4;
            }
        }
        if (this.readState == 4) {
            byte[] msgBuffer = this.rcvData;
            this.rcvData = null;
            this.readState = 0;
            return this.decoder.decodeMessage(this.rcvType, this.rcvLength, msgBuffer);
        }
        throw new IOException("invalid state: " + this.readState);
    }

    public void write(Packable pkt) throws IOException {
        byte[] data = this.pktWrapper.makeWrappedPacket(pkt);
        this.out.write(data);
    }

    public boolean send(Packable pkt) {
        try {
            this.write(pkt);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (!this.closed) {
            try {
                this.flush();
                this.socket.close();
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    public void finalize() {
        this.close();
    }
}

