/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.nda.IntervalRequest;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class TimeSeriesRequest
extends IntervalRequest {
    public static final int MSG_TYPE = 230;
    private int sampleRate;

    public TimeSeriesRequest() {
        this(0, 0, 0, 0);
    }

    public TimeSeriesRequest(int channelKey, int startSec, int endSec, int outputRate) {
        super(channelKey, startSec, endSec);
        this.sampleRate = outputRate;
    }

    public TimeSeriesRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return super.getDataLength() + 4;
    }

    public int getDataType() {
        return 230;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int dataLength = this.getDataLength();
        if (length < dataLength || offset + dataLength > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        super.readFrom(buffer, offset, length);
        this.sampleRate = BigEndian.readInt(buffer, offset += super.getDataLength());
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        BigEndian.writeInt(buffer, offset += super.getDataLength(), this.sampleRate);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    protected String toStringEx() {
        return ", " + this.sampleRate;
    }
}

