/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class CallbackServer
extends ServerSocket {
    protected static int MIN_SLEEP = 100;
    protected static int MAX_SLEEP = 2000;
    int maxCallbacks = 5;

    public CallbackServer(int port, int backlog, int maxTries) throws IOException {
        super(port, backlog);
        if (maxTries > 0) {
            this.maxCallbacks = maxTries;
        }
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Socket accept() throws IOException {
        Socket s = super.accept();
        InetAddress clientAddr = s.getInetAddress();
        int clientPort = s.getPort();
        s.close();
        int sleepTime = MIN_SLEEP;
        int tries = 0;
        while (tries < this.maxCallbacks) {
            CallbackServer.sleep(sleepTime);
            try {
                s = new Socket(clientAddr, clientPort);
                return s;
            }
            catch (IOException iOException) {
                if ((sleepTime *= 2) > MAX_SLEEP) {
                    sleepTime = MAX_SLEEP;
                }
                ++tries;
            }
        }
        throw new IOException("Callback connection refused after " + this.maxCallbacks + " tries");
    }

    public static Socket connect(InetAddress addr, int port, int maxWait) throws IOException {
        Socket s = new Socket(addr, port);
        int localPort = s.getLocalPort();
        s.close();
        ServerSocket ss = new ServerSocket(localPort, 5);
        ss.setSoTimeout(maxWait);
        s = ss.accept();
        ss.close();
        return s;
    }
}

