/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DatagramSender {
    private DatagramSocket ds;
    private InetAddress addr;
    private int port;

    public DatagramSender(String host, int _port, int localPort) throws IOException {
        this.addr = host != null ? InetAddress.getByName(host) : InetAddress.getLocalHost();
        this.ds = localPort > 0 ? new DatagramSocket(localPort) : new DatagramSocket();
        this.port = _port;
    }

    public DatagramSender(String target, int _port) throws IOException {
        this(target, _port, 0);
    }

    public void send(byte[] message) throws IOException {
        this.ds.send(new DatagramPacket(message, message.length, this.addr, this.port));
    }

    public DatagramSocket getSocket() {
        return this.ds;
    }

    public String getAddress() {
        return this.addr.getHostAddress();
    }

    public int getRemotePort() {
        return this.port;
    }

    public int getLocalPort() {
        return this.ds.getLocalPort();
    }
}

