/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import ca.nanometrics.net.CallbackServer;
import ca.nanometrics.net.ConnectionHandler;
import ca.nanometrics.net.ConnectionHandlerFactory;
import ca.nanometrics.net.ConnectionMonitor;
import ca.nanometrics.net.MultiServerConfig;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.Runner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;

public class MultiServer
extends Runner {
    private static final int WDG_LOOP_TIMEOUT = 60;
    private ConnectionHandlerFactory factory;
    private int port;
    private int maxConn;
    private boolean callback = false;
    private int timeoutMillis = 10000;
    private ServerSocket server;
    private ConnectionMonitor monitor = new ConnectionMonitor();
    private String lastReport;
    private int connectionCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public MultiServer(int portNum, int connLimit, boolean useCallback, ConnectionHandlerFactory handlerFactory) {
        this.port = portNum;
        this.maxConn = connLimit;
        this.callback = useCallback;
        this.factory = handlerFactory;
        this.setWdgTimeout(60);
        this.resetStatus();
    }

    public MultiServer(MultiServerConfig config, ConnectionHandlerFactory handlerFactory) {
        this(config.getPort(), config.getMaxConn(), config.isCallback(), handlerFactory);
    }

    protected void open() {
        this.setPriority(8);
        try {
            this.server = this.callback ? new CallbackServer(this.port, 5, 0) : new ServerSocket(this.port, 5);
            this.server.setSoTimeout(3000);
            Log.report(this, 1, 2, "starting with priority " + this.getPriority());
            Log.report(this, 4, 2, "listening on port " + this.server.getLocalPort());
        }
        catch (IOException ioe) {
            this.stayAlive = false;
            Log.report(this, 11, 5, "Cannot start service: " + ioe.getMessage());
        }
    }

    protected ConnectionHandler createHandler(Socket socket) {
        try {
            return this.factory.createHandler(socket);
        }
        catch (Exception any) {
            return null;
        }
    }

    protected void handleConnection(Socket socket) {
        ConnectionHandler handler = this.createHandler(socket);
        if (handler != null) {
            handler.start();
            this.monitor.addThread(handler);
            ++this.connectionCount;
            Log.report(this, 0, 2, "Got connection (" + this.monitor.getThreadCount() + ") from " + handler.connectionName());
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void acceptConnection() {
        try {
            Socket socket = this.server.accept();
            this.handleConnection(socket);
        }
        catch (InterruptedIOException iioe) {
            this.sleep(1000L);
        }
        catch (IOException ioe) {
            Log.report(this, 26, 4, "Server error: " + ioe.getMessage());
        }
    }

    protected void close() {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException ioe) {
            Log.report(this, 20, 4, "Unable to close server socket.");
        }
        this.monitor.removeAllThreads();
    }

    public void run() {
        this.setWdgTimeout(60);
        this.open();
        while (this.stayAlive) {
            this.setWdgTimeout(60);
            this.monitor.removeDeadThreads();
            if (this.monitor.getThreadCount() < this.maxConn) {
                this.acceptConnection();
                continue;
            }
            this.sleep(1000L);
        }
        this.close();
        Log.report(this, 18, 2, "Stopped.");
    }

    protected synchronized void reportStatus() {
        Log.report(this, 0, 2, "New connections since " + this.lastReport + ": " + this.connectionCount);
        Log.report(this, 0, 2, "Current number of connections: " + this.monitor.getThreadCount());
        this.monitor.listAllThreads();
    }

    protected void resetStatus() {
        this.lastReport = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.connectionCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }

    public void reportStatus(String hint) {
        if (hint.equals("ALL") || hint.equals("SUMMARY") || hint.equals("CONNECTIONS")) {
            this.reportStatus();
        }
    }
}

