/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class DoDRequestPacket
extends HrdCommandPacket {
    static final int CMD_TYPE = 3;
    static final int OFFSET_TO_CHANNEL = 7;
    static final int OFFSET_TO_REQTYPE = 8;
    static final int OFFSET_TO_SPARE_0 = 9;
    static final int OFFSET_TO_START_TIME = 10;
    static final int OFFSET_TO_END_TIME = 14;
    static final int OFFSET_TO_MAX_TIME = 18;
    static final int OFFSET_TO_SPARE_2 = 22;

    public DoDRequestPacket(int timeSecs, int instrumentID, int channel, int firstTime, int lastTime, int maxTime) {
        this(timeSecs, instrumentID, 0, channel, firstTime, lastTime, maxTime);
    }

    public DoDRequestPacket(int timeSecs, int instrumentID, int reqType, int channel, int firstTime, int lastTime, int maxTime) {
        super(timeSecs, instrumentID, 3);
        this.packet[7] = (byte)channel;
        this.packet[8] = (byte)reqType;
        this.packet[9] = 0;
        LittleEndian.writeInt(this.packet, 10, firstTime);
        LittleEndian.writeInt(this.packet, 14, lastTime);
        LittleEndian.writeInt(this.packet, 18, maxTime);
        LittleEndian.writeInt(this.packet, 22, 0);
    }

    public DoDRequestPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    private int _getChannel() {
        return this.packet[7] & 0xFF;
    }

    private int _getKeyType() {
        return this.packet[8];
    }

    public int getChannel() {
        int channel = this._getChannel();
        int type = this._getKeyType();
        if (type == 0 && channel == 255) {
            channel = 0;
        }
        return channel;
    }

    public String getChannelName() {
        int channel = this.getChannel();
        int type = this.getKeyType();
        if (type == 2) {
            return "Soh";
        }
        if (type == 6) {
            return "S" + channel;
        }
        return "" + channel;
    }

    public int getKeyType() {
        int channel = this._getChannel();
        int type = this._getKeyType();
        if (type == 0) {
            type = channel == 255 ? 2 : 1;
        }
        return type;
    }

    public int getStartTime() {
        return LittleEndian.readInt(this.packet, 10);
    }

    public int getMaxTime() {
        return LittleEndian.readInt(this.packet, 18);
    }

    public int getEndTime() {
        return LittleEndian.readInt(this.packet, 14);
    }

    public int getRequestedKey() {
        return this.getKey();
    }

    public String toString() {
        return "DoDRequest " + this.getInstrumentName() + ":" + this.getChannelName() + " " + this.getStartTime() + "-" + this.getEndTime();
    }
}

