/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.EntryField;
import ca.nanometrics.uitools.NmxHelp;
import javax.swing.text.PlainDocument;

public class CharEntryField
extends EntryField {
    private static final String alphaSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private String permitted;
    private int initValue;

    public CharEntryField(int value, String helpKey, String permittedChars) {
        super(new PlainDocument(), helpKey);
        this.permitted = permittedChars != null ? permittedChars : alphaSet;
        this.setHorizontalAlignment(2);
        this.setToolTipText(NmxHelp.getToolTip(helpKey));
        this.setValue(value, true);
    }

    public CharEntryField(int value, String helpKey) {
        this(value, helpKey, null);
    }

    public CharEntryField(int value) {
        this(value, null, null);
    }

    public boolean isChanged() {
        return this.getValue() != this.initValue;
    }

    public boolean isValid() {
        String text = this.getText().trim();
        return text.length() == 1 && this.permitted.indexOf(text) >= 0;
    }

    public char getChar() {
        String text = this.getText().trim();
        if (text.length() > 0) {
            return text.charAt(0);
        }
        return this.permitted.charAt(0);
    }

    public int getValue() {
        return this.getChar();
    }

    public void setValue(int val, boolean init) {
        if (init) {
            this.initValue = val;
        }
        char entry = (char)val;
        this.setText(String.valueOf(entry));
        this.checkValue();
    }

    public void setValue(int val) {
        this.setValue(val, false);
    }

    public void initValue(int val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
    }
}

