/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.BaseLabel;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.PopupHelp;
import java.awt.Color;
import javax.swing.UIManager;

public class DisplayField
extends BaseLabel {
    private Color foregroundColor = Color.black;
    private Color backgroundColor = Color.white;
    private Color emptyColor = Color.lightGray;
    private boolean isEmpty = false;

    public DisplayField(String text, String keyword) {
        super(text);
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TextField.foreground"));
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setBorder(UIManager.getBorder("TextField.border"));
        if (keyword != null) {
            this.setToolTipText(NmxHelp.getToolTip(keyword));
            if (NmxHelp.hasHelp(keyword)) {
                String fieldName = NmxHelp.getFieldName(keyword, keyword);
                this.addMouseListener(new PopupHelp(fieldName, keyword));
            }
        }
    }

    public DisplayField(String text) {
        this(text, null);
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        super.setBackground(color);
    }

    public void setEmptyColor(Color color) {
        this.emptyColor = color;
        this.setEmpty(this.isEmpty);
    }

    public void setEmpty(boolean empty) {
        if (empty) {
            super.setForeground(this.emptyColor);
            super.setBackground(this.emptyColor);
        } else if (this.isEmpty) {
            super.setForeground(this.foregroundColor);
            super.setBackground(this.backgroundColor);
        }
        this.isEmpty = empty;
    }

    public void setText(String text) {
        this.setEmpty(false);
        super.setText(text);
    }
}

