/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DoubleEntryDocument;
import ca.nanometrics.uitools.DoubleValidator;
import ca.nanometrics.uitools.EntryField;
import ca.nanometrics.uitools.NmxHelp;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DoubleEntryField
extends EntryField {
    protected static final DoubleValidator nullValidator = new NullValidator();
    private double initValue;
    private DoubleValidator validator;
    private String formatPattern = "0.0#####";

    public DoubleEntryField(double value, DoubleValidator dv, String helpKey) {
        super(new DoubleEntryDocument(), helpKey);
        this.setValidator(dv);
        this.setHorizontalAlignment(4);
        this.setValue(value, true);
    }

    public DoubleEntryField(double value, DoubleValidator dv) {
        this(value, dv, null);
    }

    public DoubleEntryField(double value, String helpKey) {
        this(value, null, helpKey);
    }

    public DoubleEntryField(double value) {
        this(value, null, null);
    }

    public boolean isChanged() {
        return this.getValue() != this.initValue;
    }

    public boolean isValid() {
        return this.getValidator().isValid(this.getValue());
    }

    public double getInitValue() {
        return this.initValue;
    }

    public double getValue() {
        try {
            return this.parseStringToDouble(this.getText());
        }
        catch (Exception any) {
            return 0.0;
        }
    }

    public void setValue(double val, boolean init) {
        if (init) {
            this.initValue = val;
        }
        this.setText(this.getStringOf(val));
        this.checkValue();
    }

    protected String getStringOf(double val) {
        return this.getDecimalFormat().format(val);
    }

    protected DecimalFormat getDecimalFormat() {
        return new DecimalFormat(this.getFormatPattern());
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String string) {
        this.formatPattern = string;
        this.setValue(this.getValue());
    }

    protected double parseStringToDouble(String aString) throws ParseException {
        return this.getDecimalFormat().parse(aString).doubleValue();
    }

    public void setValue(double val) {
        this.setValue(val, false);
    }

    public void initValue(double val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
        this.setValue(this.getValue());
    }

    public DoubleValidator getValidator() {
        return this.validator;
    }

    public void setValidator(DoubleValidator dv) {
        this.validator = dv == null ? nullValidator : dv;
        this.setToolTipText(String.valueOf(NmxHelp.getToolTip(this.getHelpKey(), "")) + " (" + this.validator.getDescription() + ")");
    }

    protected static class NullValidator
    implements DoubleValidator {
        protected NullValidator() {
        }

        public boolean isValid(double value) {
            return true;
        }

        public String getDescription() {
            return "unconstrained";
        }
    }
}

