/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DoubleValidator;

public class DoubleRangeValidator
implements DoubleValidator {
    private double minValue;
    private double maxValue;

    public DoubleRangeValidator() {
        this.setMinValue(Double.NEGATIVE_INFINITY);
        this.setMaxValue(Double.POSITIVE_INFINITY);
    }

    public DoubleRangeValidator(double rangemin, double rangemax) {
        this.setMinValue(rangemin);
        this.setMaxValue(rangemax);
    }

    public boolean isValid(double value) {
        return this.getMinValue() <= value && value <= this.getMaxValue();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMinValue());
        sb.append(" <= x <= ");
        sb.append(this.getMaxValue());
        return sb.toString();
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(double value) {
        this.minValue = value;
    }

    public double getMinValue() {
        return this.minValue;
    }
}

