/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.EntryField;
import ca.nanometrics.uitools.IPAddressDocument;
import ca.nanometrics.uitools.IntValidator;
import ca.nanometrics.uitools.NmxHelp;
import javax.swing.text.Document;

public class IPAddressField
extends EntryField {
    public static final int UNICAST = 223;
    public static final int MULTICAST = 239;
    public static final int NETMASK = 255;
    private int initValue;
    private IPAddressDocument doc;
    private IntValidator validator;

    public IPAddressField(IPAddressDocument document, int value, String helpKey, int fieldType) {
        super(document, helpKey);
        this.doc = document;
        this.setHorizontalAlignment(4);
        this.validator = fieldType == 255 ? new IPMaskValidator() : new IPAddressValidator(fieldType);
        this.setToolTipText(String.valueOf(NmxHelp.getToolTip(this.getHelpKey(), "")) + " (" + this.validator.getDescription() + ")");
        this.setValue(value, true);
    }

    public IPAddressField(int value, String helpKey, int fieldType) {
        this(new IPAddressDocument(), value, helpKey, fieldType);
    }

    public IPAddressField(IPAddressDocument document, int value, String helpKey, boolean isMask) {
        this(document, value, helpKey, isMask ? 255 : 223);
    }

    public IPAddressField(int value, String helpKey, boolean isMask) {
        this(new IPAddressDocument(), value, helpKey, isMask);
    }

    public void setDocument(Document document) {
        boolean isDateDoc = document instanceof IPAddressDocument;
        if (this.doc != null && !isDateDoc) {
            throw new IllegalArgumentException("requires IPAddressDocument");
        }
        super.setDocument(document);
        if (isDateDoc) {
            this.doc = (IPAddressDocument)document;
        }
    }

    public boolean isChanged() {
        return this.getValue() != this.initValue;
    }

    public boolean isValid() {
        return this.validator.isValid(this.getValue());
    }

    public int getInitValue() {
        return this.initValue;
    }

    public int getValue() {
        return this.doc.getIPAddress(this.getText());
    }

    public void setValue(int val, boolean init) {
        this.setText(this.doc.getIPString(val));
        if (init) {
            this.initValue = this.getValue();
        }
        this.checkValue();
    }

    protected String getStringOf(int val) {
        return this.doc.getIPString(val);
    }

    public void setValue(int val) {
        this.setValue(val, false);
    }

    public void initValue(int val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
        this.setValue(this.getValue());
    }

    public IntValidator getValidator() {
        return this.validator;
    }

    protected class IPAddressValidator
    implements IntValidator {
        int maxAddress;

        public IPAddressValidator(int fieldType) {
            this.maxAddress = fieldType & 0xFF;
        }

        public boolean isValid(int value) {
            return (value >> 24 & 0xFF) <= this.maxAddress;
        }

        public String getDescription() {
            return "IP address up to " + this.maxAddress + ".x.x.x";
        }
    }

    protected class IPMaskValidator
    implements IntValidator {
        protected IPMaskValidator() {
        }

        public boolean isValid(int value) {
            return true;
        }

        public String getDescription() {
            return "unconstrained IP mask";
        }
    }
}

