/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.EntryField;
import ca.nanometrics.uitools.IntEntryDocument;
import ca.nanometrics.uitools.IntValidator;
import ca.nanometrics.uitools.NmxHelp;

public class IntEntryField
extends EntryField {
    protected static final IntValidator nullValidator = new NullValidator();
    private int initValue;
    private IntValidator validator;

    public IntEntryField(int value, IntValidator dv, String helpKey) {
        super(new IntEntryDocument(), helpKey);
        this.setValidator(dv);
        this.setHorizontalAlignment(4);
        this.setValue(value, true);
    }

    public IntEntryField(int value, IntValidator dv) {
        this(value, dv, null);
    }

    public IntEntryField(int value, String helpKey) {
        this(value, null, helpKey);
    }

    public IntEntryField(int value) {
        this(value, null, null);
    }

    public boolean isChanged() {
        return this.getValue() != this.initValue;
    }

    public boolean isValid() {
        return this.validator.isValid(this.getValue());
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception any) {
            return 0;
        }
    }

    public void setValue(int val, boolean init) {
        if (init) {
            this.initValue = val;
        }
        this.setText(String.valueOf(val));
        this.checkValue();
    }

    public void setValue(int val) {
        this.setValue(val, false);
    }

    public void initValue(int val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
        this.setValue(this.getValue());
    }

    public IntValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IntValidator dv) {
        this.validator = dv == null ? nullValidator : dv;
        this.setToolTipText(String.valueOf(NmxHelp.getToolTip(this.getHelpKey(), "")) + " (" + this.validator.getDescription() + ")");
    }

    protected static class NullValidator
    implements IntValidator {
        protected NullValidator() {
        }

        public boolean isValid(int value) {
            return true;
        }

        public String getDescription() {
            return "unconstrained";
        }
    }
}

