/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class NmxHelp {
    private static Properties properties = new Properties();
    private static boolean ignoreCase = false;

    public static void initialize(Object source, String filename, boolean shouldIgnoreCase) {
        properties = new Properties();
        ignoreCase = shouldIgnoreCase;
        try {
            InputStream input = source.getClass().getResourceAsStream(filename);
            properties.load(input);
            input.close();
        }
        catch (Exception input) {
            // empty catch block
        }
        try {
            FileInputStream fis = new FileInputStream(filename);
            properties.load(fis);
            fis.close();
        }
        catch (Exception fis) {
            // empty catch block
        }
        if (ignoreCase) {
            Properties temp = properties;
            properties = new Properties();
            Enumeration<?> enumeration = temp.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String text = temp.getProperty(key);
                properties.put(key.toLowerCase(), text);
            }
        }
    }

    public static void initialize(Object source, String filename) {
        NmxHelp.initialize(source, filename, false);
    }

    private static String normalizeKey(String keyword) {
        if (ignoreCase && keyword != null) {
            return keyword.toLowerCase();
        }
        return keyword;
    }

    public static String getProperty(String keyword, String defaultValue) {
        return properties.getProperty(NmxHelp.normalizeKey(keyword), defaultValue);
    }

    public static String getProperty(String keyword) {
        return properties.getProperty(NmxHelp.normalizeKey(keyword));
    }

    protected static String helpKey(String keyword) {
        return String.valueOf(keyword) + ".help";
    }

    public static String getHelp(String keyword, String defaultValue) {
        return NmxHelp.getProperty(NmxHelp.helpKey(keyword), defaultValue);
    }

    public static String getHelp(String keyword) {
        return NmxHelp.getProperty(NmxHelp.helpKey(keyword));
    }

    public static boolean hasHelp(String keyword) {
        return NmxHelp.getHelp(keyword) != null;
    }

    protected static String tipKey(String keyword) {
        return String.valueOf(keyword) + ".tip";
    }

    public static String getToolTip(String keyword, String defaultValue) {
        return NmxHelp.getProperty(NmxHelp.tipKey(keyword), defaultValue);
    }

    public static String getToolTip(String keyword) {
        return NmxHelp.getProperty(NmxHelp.tipKey(keyword));
    }

    public static boolean hasToolTip(String keyword) {
        return NmxHelp.getToolTip(keyword) != null;
    }

    protected static String fieldNameKey(String keyword) {
        return String.valueOf(keyword) + ".name";
    }

    public static String getFieldName(String keyword, String defaultValue) {
        return NmxHelp.getProperty(NmxHelp.fieldNameKey(keyword), defaultValue);
    }

    public static String getFieldName(String keyword) {
        return NmxHelp.getProperty(NmxHelp.fieldNameKey(keyword));
    }

    public static boolean hasFieldName(String keyword) {
        return NmxHelp.getFieldName(keyword) != null;
    }

    public static void list(PrintStream out) {
        properties.list(out);
    }
}

