/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.NmxHelp;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioChoice
extends JPanel {
    protected Color changedForeground = Color.blue;
    protected Color normalForeground = Color.black;
    private ButtonGroup group;
    private int initValue;
    private JRadioButton[] buttons;
    private LinkedList listeners = new LinkedList();
    private RelayHandler handler = new RelayHandler();

    public RadioChoice(String[] choices, int selection, String helpKey, boolean vertical) {
        this.group = new ButtonGroup();
        int numChoices = choices.length;
        this.buttons = new JRadioButton[numChoices];
        String toolTip = NmxHelp.getToolTip(helpKey);
        int ix = 0;
        while (ix < numChoices) {
            JRadioButton rb = new JRadioButton(choices[ix]);
            rb.addActionListener(this.handler);
            rb.setToolTipText(toolTip);
            this.buttons[ix] = rb;
            this.group.add(rb);
            ++ix;
        }
        if (vertical) {
            this.doVerticalLayout();
        } else {
            this.doHorizontalLayout();
        }
        this.setSelectedIndex(selection, true);
    }

    public RadioChoice(String[] choices, int selection, String helpKey) {
        this(choices, selection, helpKey, false);
    }

    private void doHorizontalLayout() {
        this.setLayout(new FlowLayout(1, 2, 2));
        int ix = 0;
        while (ix < this.buttons.length) {
            this.add(this.buttons[ix]);
            ++ix;
        }
    }

    private void doVerticalLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        int ix = 0;
        while (ix < this.buttons.length) {
            this.add((Component)this.buttons[ix], gbc);
            ++gbc.gridy;
            ++ix;
        }
    }

    protected void updateColors() {
        int ix = 0;
        while (ix < this.buttons.length) {
            JRadioButton button = this.buttons[ix];
            if (button.isSelected() && ix != this.initValue) {
                button.setForeground(this.changedForeground);
            } else {
                button.setForeground(this.normalForeground);
            }
            ++ix;
        }
    }

    public void setSelectedIndex(int selection, boolean init) {
        if (selection >= 0 && selection < this.buttons.length) {
            this.buttons[selection].setSelected(true);
            if (init) {
                this.initValue = selection;
            }
        }
        this.updateColors();
    }

    public int getSelectedIndex() {
        int ix = 0;
        while (ix < this.buttons.length) {
            if (this.buttons[ix].isSelected()) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public void setEnabled(boolean enabled) {
        int ix = 0;
        while (ix < this.buttons.length) {
            this.buttons[ix].setEnabled(enabled);
            ++ix;
        }
    }

    public void setEnabled(String choice, boolean enabled) {
        int ix = 0;
        while (ix < this.buttons.length) {
            if (this.buttons[ix].getText().equals(choice)) {
                this.buttons[ix].setEnabled(enabled);
            }
            ++ix;
        }
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(String command) {
        ActionEvent ev = new ActionEvent(this, 1001, command);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ActionListener listener = (ActionListener)iter.next();
            listener.actionPerformed(ev);
        }
    }

    private class RelayHandler
    implements ActionListener {
        private RelayHandler() {
        }

        public void actionPerformed(ActionEvent ev) {
            RadioChoice.this.updateColors();
            RadioChoice.this.notifyListeners(ev.getActionCommand());
        }
    }
}

