/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DateTimeDocument;
import ca.nanometrics.uitools.DelimitedDocument;
import ca.nanometrics.util.Format;

public class TimeEntryDocument
extends DelimitedDocument
implements DateTimeDocument {
    public TimeEntryDocument() {
        super("0123456789.", ":- ");
    }

    protected boolean checkIntArg(String token, int maxLength, int maxVal) {
        int val;
        if (token.length() > maxLength) {
            return false;
        }
        int n = val = token.length() > 0 ? Integer.parseInt(token) : 0;
        return val < maxVal;
    }

    protected boolean checkSeconds(String token) {
        double val;
        double d = val = token.length() > 0 ? Double.parseDouble(token) : 0.0;
        return val < 60.0;
    }

    protected boolean isTextValid(String text) {
        int numTokens;
        String[] tokens;
        block9: {
            block8: {
                block7: {
                    int length = text.length();
                    if (length < 1) {
                        return true;
                    }
                    if (this.isDelimiter(text.charAt(0))) {
                        return false;
                    }
                    try {
                        tokens = this.tokenize(text);
                        numTokens = tokens.length;
                        if (numTokens <= 3) break block7;
                        return false;
                    }
                    catch (Exception any) {
                        return false;
                    }
                }
                if (numTokens <= 0 || this.checkIntArg(tokens[0], 2, 24)) break block8;
                return false;
            }
            if (numTokens <= 1 || this.checkIntArg(tokens[1], 2, 60)) break block9;
            return false;
        }
        return numTokens <= 2 || this.checkSeconds(tokens[2]);
    }

    public double getTimeValue(String text) {
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        try {
            String[] tokens = this.tokenize(text);
            hours = Integer.parseInt(tokens[0]);
            minutes = Integer.parseInt(tokens[1]);
            seconds = Double.parseDouble(tokens[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (double)(hours * 3600 + minutes * 60) + seconds;
    }

    public String getTimeString(double time) {
        int rounder = 10000;
        double frac = Math.round(time * (double)rounder);
        time = frac / (double)rounder;
        double daytime = time % 86400.0;
        int hours = (int)(daytime / 3600.0);
        int minutes = (int)(daytime / 60.0 - (double)(hours * 60));
        double seconds = time % 60.0;
        StringBuffer sb = new StringBuffer();
        Format fmt = new Format("%07.4f");
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        sb.append(fmt.form(seconds));
        return sb.toString();
    }
}

