/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class ColumnLayout
implements LayoutManager,
Serializable {
    private int minorHgap;
    private int majorHgap;
    private int vgap;
    private int rows;
    private int minorCols;
    private int majorCols;
    private int align;
    private boolean rowAddOrder = false;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int HCENTER = 0;
    public static final int VCENTER = 0;
    private int[] rowHeights = null;
    private int[] columnWidths = null;
    public static final int MAX_COMPONENT_SIZE = 0;
    public static final int SLACK_SIZE = -1;

    public ColumnLayout(int minorCols) {
        this(minorCols, 0);
    }

    public ColumnLayout(int minorCols, int rows) {
        this(0, minorCols, rows, 2, false);
    }

    public ColumnLayout(int majorCols, int minorCols, int rows, int align, boolean rowAddOrder) {
        this.setMajorCols(majorCols);
        this.setMinorCols(minorCols);
        this.setRows(rows);
        this.setAlign(align);
        this.setRowAddOrder(rowAddOrder);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncols = this.getMinorCols(parent);
            int nrows = this.getRows(parent);
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right - this.getMinorHgap();
            int height = insets.top + insets.bottom - this.getVgap();
            int curCol = 0;
            while (curCol < ncols) {
                width += this.getMinorColumnWidth(parent, curCol, 0, nrows) + this.getMinorHgap();
                ++curCol;
            }
            int curRow = 0;
            while (curRow < nrows) {
                height += this.getRowHeight(parent, curRow) + this.getVgap();
                ++curRow;
            }
            return new Dimension(width, height);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncols = this.getMinorCols(parent);
            int nrows = this.getRows(parent);
            int majorCols = this.getMajorCols(parent);
            int availableWidth = parent.getWidth() - insets.left - insets.right - (majorCols - 1) * this.getMajorHgap();
            int majorWidth = availableWidth / majorCols;
            int majorHeight = parent.getHeight() - insets.top - insets.bottom;
            int majorX = insets.left;
            int majorY = insets.top;
            int curRowInMajorCol = 0;
            int curMajorCol = 0;
            while (curMajorCol < majorCols) {
                int numRows = curMajorCol == majorCols - 1 ? nrows - curRowInMajorCol : this.getNumRowsForMajorCol(parent, curRowInMajorCol);
                int[] colWidths = this.calcMinorColWidths(parent, majorWidth, ncols, curRowInMajorCol, numRows);
                int[] rowHeights = this.calcRowHeights(parent, ncols, curRowInMajorCol, numRows);
                int curY = majorY;
                int curRow = 0;
                while (curRow < numRows) {
                    int curX = majorX;
                    int curCol = 0;
                    while (curCol < ncols) {
                        Component comp = this.getComponentForRowCol(parent, curRow + curRowInMajorCol, curCol, nrows, ncols);
                        if (comp != null) {
                            this.layoutComponent(comp, colWidths[curCol], rowHeights[curRow], curX, curY, majorX, majorY, majorWidth, majorHeight);
                        }
                        curX += colWidths[curCol] + this.getMinorHgap();
                        ++curCol;
                    }
                    curY += rowHeights[curRow] + this.getVgap();
                    ++curRow;
                }
                majorX += majorWidth + this.getMajorHgap();
                curRowInMajorCol += numRows;
                ++curMajorCol;
            }
        }
    }

    private void layoutComponent(Component comp, int width, int height, int x, int y, int majorX, int majorY, int majorWidth, int majorHeight) {
        int maxX = majorX + majorWidth;
        int maxY = majorY + majorHeight;
        if (x + width > maxX) {
            width = Math.max(0, maxX - x);
        }
        if (y + height > maxY) {
            height = Math.max(0, maxY - y);
        }
        int compWidth = (int)comp.getPreferredSize().getWidth();
        int compHeight = (int)comp.getPreferredSize().getHeight();
        if (compWidth == 0 || compWidth > width) {
            compWidth = width;
        }
        if (compHeight == 0 || compHeight > height) {
            compHeight = height;
        }
        int hRoom = width - compWidth;
        int vRoom = height - compHeight;
        if ((this.getAlign() & 1) > 0 && hRoom > 0) {
            x += hRoom;
        } else if ((this.getAlign() & 2) == 0 && hRoom > 0) {
            x += hRoom / 2;
        }
        if ((this.getAlign() & 8) > 0 && vRoom > 0) {
            y += vRoom;
        } else if ((this.getAlign() & 4) == 0 && vRoom > 0) {
            y += vRoom / 2;
        }
        if (x > maxX) {
            x = maxX;
        }
        if (y > maxY) {
            y = maxY;
        }
        comp.setBounds(x, y, compWidth, compHeight);
    }

    public int getMinorHgap() {
        return this.minorHgap;
    }

    public void setMinorHgap(int _minorHgap) {
        this.minorHgap = _minorHgap;
    }

    public int getMajorHgap() {
        return this.majorHgap;
    }

    public void setMajorHgap(int _majorHgap) {
        this.majorHgap = _majorHgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int _vgap) {
        this.vgap = _vgap;
    }

    public int getRows() {
        return this.rows;
    }

    private int getRows(Container container) {
        if (this.getRows() > 0) {
            return this.getRows();
        }
        if (this.getMinorCols() > 0) {
            return (container.getComponentCount() - 1) / this.getMinorCols() + 1;
        }
        return 1;
    }

    public void setRows(int _rows) {
        this.rows = _rows;
    }

    public int getMinorCols() {
        return this.minorCols;
    }

    private int getMinorCols(Container container) {
        if (this.getMinorCols() > 0) {
            return this.getMinorCols();
        }
        if (this.getRows() > 0) {
            return (container.getComponentCount() - 1) / this.getRows() + 1;
        }
        return 1;
    }

    public void setMinorCols(int _minorCols) {
        this.minorCols = _minorCols;
    }

    public int getMajorCols() {
        return this.majorCols;
    }

    private int getMajorCols(Container container) {
        if (this.getMajorCols() > 0) {
            return this.getMajorCols();
        }
        int maxRow = this.getRows(container);
        int numMajorCols = 0;
        int curRow = 0;
        while (curRow < maxRow) {
            ++numMajorCols;
            curRow += this.getNumRowsForMajorCol(container, curRow);
        }
        return numMajorCols;
    }

    private int getNumRowsForMajorCol(Container container, int startRow) {
        int maxRow = this.getRows(container);
        int maxHeight = container.getHeight();
        int curHeight = 0;
        int numRows = 0;
        int curRow = startRow;
        while (curRow < maxRow) {
            if ((curHeight += this.getRowHeight(container, curRow)) > maxHeight) break;
            curHeight += this.getVgap();
            ++curRow;
            ++numRows;
        }
        return Math.max(1, numRows);
    }

    public void setMajorCols(int _majorCols) {
        this.majorCols = _majorCols;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int _align) {
        this.align = _align;
    }

    public boolean getRowAddOrder() {
        return this.rowAddOrder;
    }

    public void setRowAddOrder(boolean _rowAddOrder) {
        this.rowAddOrder = _rowAddOrder;
    }

    public int[] getRowHeights() {
        return this.rowHeights;
    }

    public int getRowHeight(int row) {
        if (this.rowHeights == null || this.rowHeights.length <= 0) {
            return 0;
        }
        if (this.rowHeights.length <= row) {
            return this.rowHeights[this.rowHeights.length - 1];
        }
        return this.rowHeights[row];
    }

    public void setRowHeights(int[] _rowHeights) {
        this.rowHeights = _rowHeights;
    }

    public void setRowHeight(int _rowHeight) {
        this.setRowHeights(new int[]{_rowHeight});
    }

    private int getRowHeight(Container container, int row) {
        if (this.getRowHeight(row) > 0) {
            return this.getRowHeight(row);
        }
        if (this.getRowHeight(row) == -1) {
            return 0;
        }
        int maxHeight = 0;
        int nrows = this.getRows(container);
        int ncols = this.getMinorCols(container);
        int curCol = 0;
        while (curCol < ncols) {
            Component comp = this.getComponentForRowCol(container, row, curCol, nrows, ncols);
            if (comp == null) break;
            if (comp.getPreferredSize().getHeight() > (double)maxHeight) {
                maxHeight = (int)comp.getPreferredSize().getHeight();
            }
            ++curCol;
        }
        return maxHeight;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public int getColumnWidth(int column) {
        if (this.columnWidths == null || this.columnWidths.length <= 0) {
            return 0;
        }
        if (this.columnWidths.length <= column) {
            return this.columnWidths[this.columnWidths.length - 1];
        }
        return this.columnWidths[column];
    }

    public void setColumnWidths(int[] _columnWidths) {
        this.columnWidths = _columnWidths;
    }

    public void setColumnWidth(int _columnWidth) {
        this.setColumnWidths(new int[]{_columnWidth});
    }

    private int getMinorColumnWidth(Container container, int column, int startingRow, int numRows) {
        if (this.getColumnWidth(column) > 0) {
            return this.getColumnWidth(column);
        }
        if (this.getColumnWidth(column) == -1) {
            return 0;
        }
        int maxWidth = 0;
        int nrows = this.getRows(container);
        int ncols = this.getMinorCols(container);
        int curRow = 0;
        while (curRow < numRows) {
            Component comp = this.getComponentForRowCol(container, curRow + startingRow, column, nrows, ncols);
            if (comp == null) break;
            if (comp.getPreferredSize().getWidth() > (double)maxWidth) {
                maxWidth = (int)comp.getPreferredSize().getWidth();
            }
            ++curRow;
        }
        return maxWidth;
    }

    private Component getComponentForRowCol(Container container, int row, int col, int nrows, int ncols) {
        int index = 0;
        index = this.getRowAddOrder() ? col * nrows + row : row * ncols + col;
        if (index >= container.getComponentCount()) {
            return null;
        }
        return container.getComponent(index);
    }

    private int[] calcMinorColWidths(Container container, int majorWidth, int ncols, int startRow, int numRows) {
        int[] colWidths = new int[ncols];
        int availableWidth = majorWidth - (ncols - 1) * this.getMinorHgap();
        int numSlackObjects = 0;
        int curCol = 0;
        while (curCol < ncols) {
            colWidths[curCol] = this.getMinorColumnWidth(container, curCol, startRow, numRows);
            availableWidth -= colWidths[curCol];
            if (colWidths[curCol] == 0) {
                ++numSlackObjects;
            }
            ++curCol;
        }
        if (availableWidth > 0 && numSlackObjects > 0) {
            curCol = 0;
            while (curCol < ncols) {
                if (colWidths[curCol] == 0) {
                    colWidths[curCol] = availableWidth / numSlackObjects;
                }
                ++curCol;
            }
        }
        return colWidths;
    }

    private int[] calcRowHeights(Container container, int ncols, int startRow, int numRows) {
        int[] rowHeights = new int[numRows];
        int availableHeight = container.getHeight() - (numRows - 1) * this.getVgap();
        int numSlackObjects = 0;
        int curRow = 0;
        while (curRow < numRows) {
            rowHeights[curRow] = this.getRowHeight(container, curRow + startRow);
            availableHeight -= rowHeights[curRow];
            if (rowHeights[curRow] == 0) {
                ++numSlackObjects;
            }
            ++curRow;
        }
        if (availableHeight > 0 && numSlackObjects > 0) {
            curRow = 0;
            while (curRow < numRows) {
                if (rowHeights[curRow] == 0) {
                    rowHeights[curRow] = availableHeight / numSlackObjects;
                }
                ++curRow;
            }
        }
        return rowHeights;
    }
}

