/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class PrefGridLayout
implements LayoutManager,
Serializable {
    int hgap;
    int vgap;
    int rows;
    int cols;
    int align;
    boolean rowAddOrder = false;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int HCENTER = 0;
    public static final int VCENTER = 0;

    public PrefGridLayout() {
        this(1, 0, 0, 0, 0, false);
    }

    public PrefGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0, 0, false);
    }

    public PrefGridLayout(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, hgap, vgap, 0, false);
    }

    public PrefGridLayout(int rows, int cols, int hgap, int vgap, int align) {
        this(rows, cols, hgap, vgap, align, false);
    }

    public PrefGridLayout(int rows, int cols, int hgap, int vgap, int align, boolean rowAddOrder) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.align = align;
        this.rowAddOrder = rowAddOrder;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public int getAlign() {
        return this.align;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private int getColumnWidth(Container parent, int column) {
        int nrows = this.getNumberRows(parent);
        int ncols = this.getNumberCols(parent);
        int numComponents = parent.getComponentCount();
        int maxWidth = 0;
        int curRow = 0;
        while (curRow < nrows) {
            int index = this.getIndexForRowCol(curRow, column, nrows, ncols);
            if (index >= numComponents) break;
            Dimension dim = parent.getComponent(index).getPreferredSize();
            if (maxWidth < dim.width) {
                maxWidth = dim.width;
            }
            ++curRow;
        }
        return maxWidth;
    }

    private int getNumberCols(Container parent) {
        if (this.rows > 0) {
            return (parent.getComponentCount() + this.rows - 1) / this.rows;
        }
        return this.cols;
    }

    private int getNumberRows(Container parent) {
        if (this.cols > 0) {
            return (parent.getComponentCount() + this.cols - 1) / this.cols;
        }
        return this.rows;
    }

    private int getIndexForRowCol(int row, int col, int nrows, int ncols) {
        if (this.getRowAddOrder()) {
            return col * nrows + row;
        }
        return row * ncols + col;
    }

    private int getRowHeight(Container parent, int row) {
        int nrows = this.getNumberRows(parent);
        int ncols = this.getNumberCols(parent);
        int numComponents = parent.getComponentCount();
        int maxHeight = 0;
        int curCol = 0;
        while (curCol < ncols) {
            int index = this.getIndexForRowCol(row, curCol, nrows, ncols);
            if (index >= numComponents) break;
            Dimension dim = parent.getComponent(index).getPreferredSize();
            if (maxHeight < dim.height) {
                maxHeight = dim.height;
            }
            ++curCol;
        }
        return maxHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getNumberRows(parent);
            int ncols = this.getNumberCols(parent);
            int w = 0;
            int h = 0;
            int i = 0;
            while (i < ncols) {
                w += this.getColumnWidth(parent, i);
                ++i;
            }
            i = 0;
            while (i < nrows) {
                h += this.getRowHeight(parent, i);
                ++i;
            }
            return new Dimension(insets.left + insets.right + w + (ncols - 1) * this.hgap, insets.top + insets.bottom + h + (nrows - 1) * this.vgap);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getNumberRows(parent);
            int ncols = this.getNumberCols(parent);
            if (ncomponents == 0) {
                return;
            }
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            w = (w - (ncols - 1) * this.hgap) / ncols;
            h = (h - (nrows - 1) * this.vgap) / nrows;
            int c = 0;
            int x = insets.left;
            while (c < ncols) {
                int colWidth = this.getColumnWidth(parent, c);
                int r = 0;
                int y = insets.top;
                while (r < nrows) {
                    int i = this.getIndexForRowCol(r, c, nrows, ncols);
                    int rowHeight = this.getRowHeight(parent, r);
                    if (i < ncomponents) {
                        Component comp = parent.getComponent(i);
                        Dimension prefSize = comp.getPreferredSize();
                        int hRoom = colWidth - (int)prefSize.getWidth();
                        int vRoom = rowHeight - (int)prefSize.getHeight();
                        if ((this.align & 2) > 0) {
                            hRoom = 0;
                        } else if ((this.align & 1) == 0) {
                            hRoom /= 2;
                        }
                        if ((this.align & 4) > 0) {
                            vRoom = 0;
                        } else if ((this.align & 8) == 0) {
                            vRoom /= 2;
                        }
                        parent.getComponent(i).setBounds(x + hRoom, y + vRoom, (int)prefSize.getWidth(), (int)prefSize.getHeight());
                    }
                    y += rowHeight + this.vgap;
                    ++r;
                }
                x += colWidth + this.hgap;
                ++c;
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }

    public boolean getRowAddOrder() {
        return this.rowAddOrder;
    }
}

