/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.plot;

import ca.nanometrics.uitools.plot.ScalarRange;

public class SimpleRounder {
    private static double[] msize = new double[]{1.0, 1.2, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0};
    private static int[] ntics = new int[]{2, 3, 3, 4, 5, 3, 4, 5, 3, 4, 2};
    private double defscale = 1.0;

    public SimpleRounder() {
    }

    public SimpleRounder(double scale) {
        if (scale != 0.0) {
            this.defscale = scale;
        }
    }

    public ScalarRange getRange(double v1, double v2) {
        return this.getRange(new ScalarRange(v1, v2));
    }

    public ScalarRange getRange(ScalarRange raw) {
        double xmin = raw.getMin();
        double xmax = raw.getMax();
        if (xmin == 0.0 && xmax == 0.0) {
            return new ScalarRange(-this.defscale, this.defscale);
        }
        double prod = xmin * xmax;
        double xamin = Math.abs(xmin);
        double xamax = Math.abs(xmax);
        double xsma = xamin;
        double xbig = xamax;
        if (xamin > xamax) {
            xsma = xamax;
            xbig = xamin;
        }
        double xrat = xsma / xbig;
        double xrange = 1.0;
        while (xbig < xrange) {
            xrange /= 10.0;
        }
        while (xbig > 10.0 * xrange) {
            xrange *= 10.0;
        }
        double test = xbig / xrange - 1.0E-4;
        int ix = 0;
        while (ix < msize.length) {
            if (test <= msize[ix]) break;
            ++ix;
        }
        if (ix >= msize.length) {
            ix = msize.length - 1;
        }
        double xscale = xrange * msize[ix];
        int ntica = ntics[ix];
        if (prod < 0.0 && xrat > 0.3) {
            return new ScalarRange(-xscale, xscale);
        }
        if (prod < 0.0) {
            int iex = 1;
            while (iex < ntica) {
                if (xsma <= (double)iex * xscale / (double)ntica) break;
                ++iex;
            }
            double xscal2 = (double)iex * xscale / (double)ntica;
            if (xamin > xamax) {
                return new ScalarRange(-xscale, xscal2);
            }
            return new ScalarRange(-xscal2, xscale);
        }
        if (xsma / xscale < 0.5) {
            if (xamin > xamax) {
                return new ScalarRange(-xscale, 0.0);
            }
            return new ScalarRange(0.0, xscale);
        }
        double xdiff = (xbig - xsma) / 2.0;
        double xavg = (xbig + xsma) / 2.0;
        double maxrat = 1000000.0;
        if (xdiff < xbig / maxrat) {
            xdiff = xbig / maxrat;
        }
        xrange = 1.0;
        while (xdiff < xrange) {
            xrange /= 10.0;
        }
        while (xdiff > 10.0 * xrange) {
            xrange *= 10.0;
        }
        test = xdiff / xrange;
        ix = 0;
        while (ix < msize.length) {
            if (test <= msize[ix]) break;
            ++ix;
        }
        double xmid = 0.0;
        while ((xmid = (xscale = xrange * msize[ix]) * Math.rint(xavg / xscale)) - xscale > xsma || xmid + xscale < xbig) {
            if (++ix < msize.length) continue;
            ix = 0;
            xrange *= 10.0;
        }
        if (xmax < 0.0) {
            xmid = -xmid;
        }
        return new ScalarRange(xmid - xscale, xmid + xscale);
    }
}

