/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.table;

import ca.nanometrics.uitools.table.TableRow;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class VectorTableModel
extends AbstractTableModel {
    protected Vector rows = new Vector();
    private TableRow rowModel = new EmptyRow();

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public void setPrototype(TableRow model) {
        this.rowModel = model == null ? new EmptyRow() : model;
    }

    public void setRows(Vector rowVector) {
        this.rows.removeAllElements();
        Enumeration e = rowVector.elements();
        while (e.hasMoreElements()) {
            Object row = e.nextElement();
            if (!(row instanceof TableRow)) continue;
            this.rows.addElement(row);
        }
        this.fireTableDataChanged();
    }

    public void entryUpdated(TableRow entry) {
        int index = this.rows.indexOf(entry);
        if (index >= 0) {
            this.fireTableRowsUpdated(index, index);
        }
    }

    public void addRow(TableRow row) {
        if (row != null) {
            this.rows.addElement(row);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(TableRow row) {
        this.rows.removeElement(row);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.rowModel.getColumnCount();
    }

    public String getColumnName(int col) {
        return this.rowModel.getColumnName(col);
    }

    public Class getColumnClass(int col) {
        return this.rowModel.getColumnClass(col);
    }

    public Object getValueAt(int row, int col) {
        TableRow rowobj = (TableRow)this.rows.elementAt(row);
        return rowobj.getValueAt(col);
    }

    public void setValueAt(Object value, int row, int col) {
        TableRow rowobj = (TableRow)this.rows.elementAt(row);
        rowobj.setValueAt(value, col);
    }

    public boolean isCellEditable(int row, int col) {
        TableRow rowobj = (TableRow)this.rows.elementAt(row);
        return rowobj.isCellEditable(col);
    }

    public Enumeration elements() {
        return this.rows.elements();
    }

    public TableRow getRow(int index) {
        if (index < this.rows.size()) {
            return (TableRow)this.rows.get(index);
        }
        return null;
    }

    private class EmptyRow
    implements TableRow {
        private EmptyRow() {
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int columnIndex) {
            return "Invalid";
        }

        public Class getColumnClass(int columnIndex) {
            return null;
        }

        public TableCellRenderer getColumnRenderer(int col) {
            return null;
        }

        public boolean isCellEditable(int columnIndex) {
            return false;
        }

        public Object getValueAt(int columnIndex) {
            return null;
        }

        public void setValueAt(Object aValue, int columnIndex) {
        }

        public int getPreferredWidth(int columnIndex) {
            return 50;
        }
    }
}

