/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.List;

public class NmxDragDropEvent {
    private DropTargetDragEvent dragEvent = null;
    private DropTargetDropEvent dropEvent = null;
    public static final int ACTION_COPY = 1;
    public static final int ACTION_MOVE = 2;
    private boolean eventAccepted = false;
    private int mouseX = 0;
    private int mouseY = 0;

    public NmxDragDropEvent(DropTargetDragEvent dragEvent) {
        this.dragEvent = dragEvent;
        this.mouseX = dragEvent.getLocation().x;
        this.mouseY = dragEvent.getLocation().y;
    }

    public NmxDragDropEvent(DropTargetDropEvent dropEvent) {
        this.dropEvent = dropEvent;
        this.mouseX = dropEvent.getLocation().x;
        this.mouseY = dropEvent.getLocation().y;
    }

    public void acceptEvent(int actionType) {
        if (this.dragEvent != null) {
            this.dragEvent.acceptDrag(actionType);
        }
        this.eventAccepted = true;
    }

    public boolean isAccepted() {
        return this.eventAccepted;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.dragEvent != null) {
            return this.dragEvent.isDataFlavorSupported(flavor);
        }
        if (this.dropEvent != null) {
            return this.dropEvent.isDataFlavorSupported(flavor);
        }
        return false;
    }

    public List getCurrentDataFlavors() {
        if (this.dragEvent != null) {
            return this.dragEvent.getCurrentDataFlavorsAsList();
        }
        if (this.dropEvent != null) {
            return this.dropEvent.getCurrentDataFlavorsAsList();
        }
        return null;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }
}

