/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArray {
    private byte[] m_array;
    private int m_length;
    private int m_offset;

    public ByteArray(byte[] array) {
        this.setArray(array);
    }

    public ByteArray(byte[] array, int offset, int length) {
        this.setArray(array, offset, length);
    }

    public ByteArray(ByteArray bigArray, int offset, int length) {
        this.setArray(bigArray.getArray(), bigArray.getOffset() + offset, length);
    }

    public byte[] getArray() {
        return this.m_array;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public byte get(int index) {
        int myOffset = this.m_offset + index;
        if (myOffset >= this.m_array.length || myOffset >= this.m_offset + this.m_length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.m_array[myOffset];
    }

    public byte[] get(int beginIndex, int endIndex) {
        int myBeginOffset = beginIndex + this.m_offset;
        if (myBeginOffset > this.m_offset + this.m_length || myBeginOffset > this.m_array.length) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        int myEndOffset = endIndex + this.m_offset;
        if (myEndOffset > this.m_offset + this.m_length || myEndOffset > this.m_array.length) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        byte[] buffer = new byte[endIndex - beginIndex];
        System.arraycopy(this.m_array, myBeginOffset, buffer, 0, buffer.length);
        return buffer;
    }

    public void set(byte b, int index) {
        if (index + this.m_offset >= this.m_offset + this.m_length || index + this.m_offset >= this.m_array.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.m_array[this.m_offset + index] = b;
    }

    public void set(byte[] b, int index) {
        if (b == null) {
            return;
        }
        if (b.length + this.m_offset >= this.m_length) {
            throw new ArrayIndexOutOfBoundsException(index + b.length);
        }
        System.arraycopy(b, 0, this.m_array, index, b.length);
    }

    public void write(DataOutput stream) throws IOException {
        if (this.m_array == null || this.m_array.length < 1 || this.m_length < 1 || this.m_length + this.m_offset > this.m_array.length) {
            return;
        }
        stream.write(this.m_array, this.m_offset, this.m_length);
    }

    public void write(DataOutputStream stream) throws IOException {
        if (this.m_array == null || this.m_array.length < 1 || this.m_length < 1 || this.m_length + this.m_offset > this.m_array.length) {
            return;
        }
        stream.write(this.m_array, this.m_offset, this.m_length);
    }

    public void write(OutputStream stream) throws IOException {
        if (this.m_array == null || this.m_array.length < 1 || this.m_length < 1 || this.m_length + this.m_offset > this.m_array.length) {
            return;
        }
        stream.write(this.m_array, this.m_offset, this.m_length);
    }

    private void setArray(byte[] array) {
        this.setArray(array, 0, array.length);
    }

    private void setArray(byte[] array, int offset, int length) {
        this.m_array = array;
        this.m_offset = offset;
        this.m_length = length;
    }

    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.m_array, this.m_offset, this.m_length);
    }

    public ByteArrayInputStream getInputStream(int offset, int length) {
        return new ByteArrayInputStream(this.m_array, this.m_offset + offset, length);
    }

    public int getLength() {
        return this.m_length;
    }

    public Object clone() {
        byte[] bytes = new byte[this.m_length];
        System.arraycopy(this.m_array, this.m_offset, bytes, 0, this.m_length);
        return new ByteArray(bytes);
    }
}

