/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.HierarchalObservable;
import ca.nanometrics.util.HierarchalObservableChanged;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class HierarchalObservableChangedList
extends HierarchalObservableChanged {
    private List components;

    public HierarchalObservableChangedList() {
        this.leaf = false;
        this.components = new ArrayList();
    }

    public boolean hasChanged(HierarchalObservable aHierarchalObservable) {
        Iterator i = this.getComponents();
        while (i.hasNext()) {
            if (!((HierarchalObservableChanged)i.next()).hasChanged(aHierarchalObservable)) continue;
            return true;
        }
        return false;
    }

    public Set getChangedClasses() {
        HashSet classes = new HashSet();
        Iterator i = this.getComponents();
        while (i.hasNext()) {
            Set changedClasses = ((HierarchalObservableChanged)i.next()).getChangedClasses();
            classes.addAll(changedClasses);
        }
        return classes;
    }

    public boolean hasClassChangedOtherThan(Class[] ignoreClasses) {
        List<Class> ignoreList = Arrays.asList(ignoreClasses);
        Iterator curClass = this.getChangedClasses().iterator();
        boolean foundClass = false;
        while (curClass.hasNext()) {
            Class changedClass = (Class)curClass.next();
            if (ignoreList.contains(changedClass)) continue;
            foundClass = true;
            break;
        }
        return foundClass;
    }

    public boolean hasClassChanged(Class aClass) {
        Iterator i = this.getComponents();
        while (i.hasNext()) {
            if (!((HierarchalObservableChanged)i.next()).hasClassChanged(aClass)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HierarchalObservable aHierarchalObservable) {
        Iterator i = this.getComponents();
        while (i.hasNext()) {
            if (!((HierarchalObservableChanged)i.next()).contains(aHierarchalObservable)) continue;
            return true;
        }
        return false;
    }

    public boolean containsClass(Class aClass) {
        Iterator i = this.getComponents();
        while (i.hasNext()) {
            if (!((HierarchalObservableChanged)i.next()).containsClass(aClass)) continue;
            return true;
        }
        return false;
    }

    public Iterator getComponents() {
        return this.components.iterator();
    }

    public void addComponent(HierarchalObservableChanged component) throws NoSuchElementException {
        this.components.add(component);
    }

    public void removeComponent(HierarchalObservableChanged component) throws NoSuchElementException {
        this.components.remove(component);
    }
}

