/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.ByteArrayHelper;

public class IntegerHelper {
    private IntegerHelper() {
    }

    public static int nextClosestDivisible(int num, int divisor) {
        if (num % divisor == 0) {
            return num;
        }
        int mod = num % divisor;
        return num + (divisor - mod);
    }

    public static long signedToUnsignedInt(int signedInt) {
        long unsignedInt = signedInt;
        if (signedInt < 0) {
            unsignedInt &= 0xFFFFFFFFL;
        }
        return unsignedInt;
    }

    public static int signedToUnsignedIntOneByte(int signedInt) {
        int bitsInByte = 8;
        int unsignedInt = signedInt;
        if (signedInt < 0) {
            unsignedInt = signedInt & 0xFF;
        }
        return unsignedInt;
    }

    public static String signedToUnsignedHexString(int signedInt) {
        long unsignedInt = IntegerHelper.signedToUnsignedInt(signedInt);
        return Long.toHexString(unsignedInt);
    }

    public static char nibbletoHex(int nibble) {
        char[] hexDigitArray = ByteArrayHelper.gethexDigitArray();
        return hexDigitArray[nibble & 0xF];
    }
}

