/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.yfile.YSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class SeriesInfo
extends YSection {
    public static final int TAG_NUMBER = 5;
    public static final int FLAG_LENGTH = 16;
    public static final int DATA_LENGTH = 64;
    static NmxDateFormat dateFormatter = new NmxDateFormat();
    byte[] updateFlags = new byte[16];
    double startTime = 0.0;
    double endTime = 0.0;
    int numSamples = 0;
    int dcOffset = 0;
    int maxAmplitude = 0;
    int minAmplitude = 0;
    byte[] format = new byte[8];
    byte[] formatVersion = new byte[8];

    public SeriesInfo() {
        super(5, 64);
        this.setFormat("YFILE");
        this.setFormatVersion("5.0");
    }

    public SeriesInfo(DataInput input) throws IOException {
        this();
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.updateFlags);
        this.startTime = input.readDouble();
        this.endTime = input.readDouble();
        this.numSamples = input.readInt();
        this.dcOffset = input.readInt();
        this.maxAmplitude = input.readInt();
        this.minAmplitude = input.readInt();
        input.readFully(this.format);
        input.readFully(this.formatVersion);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.updateFlags);
        output.writeDouble(this.startTime);
        output.writeDouble(this.endTime);
        output.writeInt(this.numSamples);
        output.writeInt(this.dcOffset);
        output.writeInt(this.maxAmplitude);
        output.writeInt(this.minAmplitude);
        output.write(this.format);
        output.write(this.formatVersion);
    }

    public void display(PrintStream out) {
        out.println("Series info:");
        out.println("  StartTime     = " + this.getStartTimeString());
        out.println("  EndTime       = " + this.getEndTimeString());
        out.println("  NumSamples    = " + this.getNumSamples());
        out.println("  DcOffset      = " + this.getDcOffset());
        out.println("  MaxAmplitude  = " + this.getMaxAmplitude());
        out.println("  MinAmplitude  = " + this.getMinAmplitude());
        out.println("  Format        = " + this.getFormat());
        out.println("  FormatVersion = " + this.getFormatVersion());
    }

    public void setStartTime(double time) {
        this.startTime = time;
    }

    public void setEndTime(double time) {
        this.endTime = time;
    }

    public void setNumSamples(int value) {
        this.numSamples = value;
    }

    public void setDcOffset(int value) {
        this.dcOffset = value;
    }

    public void setMaxAmplitude(int value) {
        this.maxAmplitude = value;
    }

    public void setMinAmplitude(int value) {
        this.minAmplitude = value;
    }

    public void setFormat(String text) {
        this.setStringField(this.format, text);
    }

    public void setFormatVersion(String text) {
        this.setStringField(this.formatVersion, text);
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getDcOffset() {
        return this.dcOffset;
    }

    public int getMaxAmplitude() {
        return this.maxAmplitude;
    }

    public int getMinAmplitude() {
        return this.minAmplitude;
    }

    public String getFormat() {
        return this.getStringField(this.format);
    }

    public String getFormatVersion() {
        return this.getStringField(this.formatVersion);
    }

    public String getStartTimeString() {
        return dateFormatter.format(this.getStartTime());
    }

    public String getEndTimeString() {
        return dateFormatter.format(this.getEndTime());
    }
}

