/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StnId {
    public static final byte BLANK = 32;
    private byte[] data = new byte[10];

    public StnId() {
        int ix = 0;
        while (ix < this.data.length) {
            this.data[ix] = 32;
            ++ix;
        }
    }

    private void sanitize() {
        int ix = 0;
        while (ix < this.data.length) {
            if (this.data[ix] == 0) {
                this.data[ix] = 32;
            }
            ++ix;
        }
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.data);
        this.sanitize();
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.data);
    }

    private String getSubString(int offset, int length) {
        String name = new String(this.data, offset, length);
        return name.trim();
    }

    private void setSubString(String name, int offset, int length) {
        byte[] nameBytes = name.getBytes();
        int ix = 0;
        while (ix < length) {
            this.data[offset + ix] = 32;
            ++ix;
        }
        int bytesToCopy = nameBytes.length;
        if (bytesToCopy > length) {
            bytesToCopy = length;
        }
        System.arraycopy(nameBytes, 0, this.data, offset, bytesToCopy);
    }

    public String getStationName() {
        return this.getSubString(0, 5);
    }

    public String getLocationName() {
        return this.getSubString(5, 2);
    }

    public String getChannelName() {
        return this.getSubString(7, 3);
    }

    public void setStationName(String name) {
        this.setSubString(name, 0, 5);
    }

    public void setLocationName(String name) {
        this.setSubString(name, 5, 2);
    }

    public void setChannelName(String name) {
        this.setSubString(name, 7, 3);
    }

    public String toString() {
        return String.valueOf(this.getStationName()) + "." + this.getLocationName() + "." + this.getChannelName();
    }
}

