/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.YSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class StnParameters
extends YSection {
    public static final int TAG_NUMBER = 3;
    public static final int FLAG_LENGTH = 16;
    public static final int DATA_LENGTH = 128;
    byte[] updateFlags = new byte[16];
    double startValidTime = 0.0;
    double endValidTime = 0.0;
    double sensitivity = 0.0;
    double sensitivityFreq = 0.0;
    double sampleRate = 0.0;
    double maxClockDrift = 0.0;
    byte[] sensitivityUnits = new byte[24];
    byte[] calibrationUnits = new byte[24];
    byte[] channelFlags = new byte[27];
    byte updateFlag = 0;
    byte[] filler = new byte[4];

    public StnParameters() {
        super(3, 128);
        this.setSampleRate(100.0);
        this.setSensitivityUnits("none");
        this.setCalibrationUnits("none");
        this.setChannelFlags("");
        this.setUpdateFlag('U');
    }

    public StnParameters(DataInput input) throws IOException {
        this();
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.updateFlags);
        this.startValidTime = input.readDouble();
        this.endValidTime = input.readDouble();
        this.sensitivity = input.readFloat();
        this.sensitivityFreq = input.readFloat();
        this.sampleRate = input.readFloat();
        this.maxClockDrift = input.readFloat();
        input.readFully(this.sensitivityUnits);
        input.readFully(this.calibrationUnits);
        input.readFully(this.channelFlags);
        this.updateFlag = input.readByte();
        input.readFully(this.filler);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.updateFlags);
        output.writeDouble(this.startValidTime);
        output.writeDouble(this.endValidTime);
        output.writeFloat((float)this.sensitivity);
        output.writeFloat((float)this.sensitivityFreq);
        output.writeFloat((float)this.sampleRate);
        output.writeFloat((float)this.maxClockDrift);
        output.write(this.sensitivityUnits);
        output.write(this.calibrationUnits);
        output.write(this.channelFlags);
        output.writeByte(this.updateFlag);
        output.write(this.filler);
    }

    public void display(PrintStream out) {
        out.println("Station Parameters:");
        out.println("  StartValidTime    = " + this.getStartValidTime());
        out.println("  EndValidTime      = " + this.getEndValidTime());
        out.println("  Sensitivity       = " + this.getSensitivity());
        out.println("  SensitivityFreq   = " + this.getSensitivityFreq());
        out.println("  SampleRate        = " + this.getSampleRate());
        out.println("  MaxClockDrift     = " + this.getMaxClockDrift());
        out.println("  UpdateFlag        = " + this.getUpdateFlag());
        out.println("  SensitivityUnits  = " + this.getSensitivityUnits());
        out.println("  CalibrationUnits  = " + this.getCalibrationUnits());
        out.println("  ChannelFlags      = " + this.getChannelFlags());
    }

    public void setStartValidTime(double time) {
        this.startValidTime = time;
    }

    public void setEndValidTime(double time) {
        this.endValidTime = time;
    }

    public void setSensitivity(double unitsPerBit) {
        this.sensitivity = unitsPerBit;
    }

    public void setSensitivityFreq(double freqHz) {
        this.sensitivityFreq = freqHz;
    }

    public void setSampleRate(double samplesPerSecond) {
        this.sampleRate = samplesPerSecond;
    }

    public void setMaxClockDrift(double secPerSample) {
        this.maxClockDrift = secPerSample;
    }

    public void setUpdateFlag(char flag) {
        this.updateFlag = (byte)flag;
    }

    public void setSensitivityUnits(String units) {
        this.setStringField(this.sensitivityUnits, units);
    }

    public void setCalibrationUnits(String units) {
        this.setStringField(this.calibrationUnits, units);
    }

    public void setChannelFlags(String flags) {
        this.setStringField(this.channelFlags, flags, 32);
    }

    public double getStartValidTime() {
        return this.startValidTime;
    }

    public double getEndValidTime() {
        return this.endValidTime;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public double getSensitivityFreq() {
        return this.sensitivityFreq;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public double getMaxClockDrift() {
        return this.maxClockDrift;
    }

    public char getUpdateFlag() {
        return (char)this.updateFlag;
    }

    public String getSensitivityUnits() {
        return this.getStringField(this.sensitivityUnits);
    }

    public String getCalibrationUnits() {
        return this.getStringField(this.calibrationUnits);
    }

    public String getChannelFlags() {
        return this.getStringField(this.channelFlags);
    }
}

