/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.DataTag;
import ca.nanometrics.yfile.SeriesInfo;
import ca.nanometrics.yfile.Y5Header;
import ca.nanometrics.yfile.YData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class Y5File {
    public static final int TAG_NUMBER = 0;
    private Y5Header header;
    private YData data;

    public Y5File() {
        this(new Y5Header(), new YData());
    }

    public Y5File(Y5Header yHeader, YData yData) {
        if (yHeader == null) {
            throw new NullPointerException("Y5File.header");
        }
        if (yData == null) {
            throw new NullPointerException("Y5File.data");
        }
        this.header = yHeader;
        this.data = yData;
    }

    public Y5File(Y5Header yHeader, int[] vals) {
        this(yHeader, new YData(vals));
    }

    public Y5File(Y5Header yHeader, int[] vals, double startTime, double sampleRate) {
        this(yHeader, new YData(vals));
        this.updateHeader(startTime, sampleRate);
    }

    public Y5File(Y5Header yHeader, double[] vals, double startTime, double sampleRate) {
        this(yHeader, new YData(vals));
        this.updateHeader(startTime, sampleRate);
    }

    public Y5File(DataInput input) throws IOException {
        this();
        this.readFrom(input);
    }

    public void readFrom(DataInput source) throws IOException {
        DataTag tag = new DataTag(source);
        if (tag.getType() != 0) {
            throw new IOException("Not a Y-File");
        }
        this.header.readHeader(source, this.data);
    }

    public void writeTo(DataOutput output) throws IOException {
        int nextSame = this.header.getDataLength() + 16 + this.data.getDataLength();
        DataTag tag = new DataTag(0, 0, nextSame);
        tag.writeTo(output);
        this.header.writeTo(output);
        DataTag.writeRecord(output, this.data);
    }

    public void updateHeader(double startTime, double sampleRate) {
        if (sampleRate <= 0.0) {
            sampleRate = 1.0;
        }
        this.header.getStnParameters().setSampleRate(sampleRate);
        SeriesInfo info = this.header.getSeriesInfo();
        info.setStartTime(startTime);
        int nSamples = this.data.getNumSamples();
        if (nSamples > 0) {
            info.setEndTime(startTime + (double)(nSamples - 1) / sampleRate);
        } else {
            info.setEndTime(startTime);
        }
        info.setNumSamples(nSamples);
        info.setDcOffset((int)Math.round(this.data.getDcOffset()));
        info.setMinAmplitude(this.data.getMinSample());
        info.setMaxAmplitude(this.data.getMaxSample());
        info.setFormat("YFILE");
        info.setFormatVersion("5.0");
    }

    public void display(PrintStream out) {
        this.header.display(out);
        this.data.display(out);
    }

    public YData getData() {
        return this.data;
    }

    public Y5Header getHeader() {
        return this.header;
    }
}

