/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.util.LittleEndianDataInput;
import ca.nanometrics.yfile.DataTag;
import ca.nanometrics.yfile.SeriesDatabase;
import ca.nanometrics.yfile.SeriesInfo;
import ca.nanometrics.yfile.StnDatabase;
import ca.nanometrics.yfile.StnInfo;
import ca.nanometrics.yfile.StnLocation;
import ca.nanometrics.yfile.StnParameters;
import ca.nanometrics.yfile.StnResponse;
import ca.nanometrics.yfile.Taggable;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;

public class Y5Header {
    public static final int FLAG_LENGTH = 16;
    public static final int TAG_Y_FILE = 0;
    public static final int TAG_X_FILE = 22;
    public static final int TAG_RBF_DATA = 33;
    private byte[] updateFlags = new byte[16];
    private StnInfo stnInfo = new StnInfo();
    private StnLocation stnLocation = new StnLocation();
    private StnParameters stnParameters = new StnParameters();
    private StnResponse stnResponse = new StnResponse();
    private SeriesDatabase dbaSeries = new SeriesDatabase();
    private StnDatabase dbaStation = new StnDatabase();
    private SeriesInfo seriesInfo = new SeriesInfo();

    public void readHeader(DataInput source, Taggable dataRec) throws IOException {
        try {
            while (true) {
                DataTag tag = new DataTag(source);
                int type = tag.getType();
                boolean fwd = tag.isForwardByteOrder();
                DataInput input = source;
                if (!tag.isForwardByteOrder()) {
                    input = new LittleEndianDataInput(source);
                }
                if (type == 0) {
                    return;
                }
                if (type == 22) {
                    return;
                }
                if (type == 33) {
                    return;
                }
                if (dataRec != null && type == dataRec.getTagNumber()) {
                    dataRec.readFrom(input, tag.getNext());
                    continue;
                }
                if (type == 1) {
                    this.stnInfo.readFrom(input);
                    continue;
                }
                if (type == 2) {
                    this.stnLocation.readFrom(input);
                    continue;
                }
                if (type == 3) {
                    this.stnParameters.readFrom(input);
                    continue;
                }
                if (type == 26) {
                    this.stnResponse.readFrom(input);
                    continue;
                }
                if (type == 4) {
                    this.dbaStation.readFrom(input);
                    continue;
                }
                if (type == 6) {
                    this.dbaSeries.readFrom(input);
                    continue;
                }
                if (type == 5) {
                    this.seriesInfo.readFrom(input);
                    continue;
                }
                input.skipBytes(tag.getNext());
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public void readHeader(DataInput source) throws IOException {
        this.readHeader(source, null);
    }

    public void writeTo(DataOutput output) throws IOException {
        DataTag.writeRecord(output, this.stnInfo);
        DataTag.writeRecord(output, this.stnLocation);
        DataTag.writeRecord(output, this.stnParameters);
        DataTag.writeRecord(output, this.dbaStation);
        DataTag.writeRecord(output, this.dbaSeries);
        DataTag.writeRecord(output, this.seriesInfo);
        DataTag.writeRecord(output, this.stnResponse);
    }

    public void display(PrintStream out) {
        out.println("Y5Header info:");
        this.stnInfo.display(out);
        this.stnLocation.display(out);
        this.stnParameters.display(out);
        this.stnResponse.display(out);
        this.dbaSeries.display(out);
        this.dbaStation.display(out);
        this.seriesInfo.display(out);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.writeTo(dos);
            dos.flush();
            return baos.toByteArray();
        }
        catch (Exception any) {
            any.printStackTrace();
            return new byte[0];
        }
    }

    public int getDataLength() {
        int length = this.stnInfo.getDataLength() + this.stnLocation.getDataLength() + this.stnParameters.getDataLength() + this.stnResponse.getDataLength() + this.dbaSeries.getDataLength() + this.dbaStation.getDataLength() + this.seriesInfo.getDataLength() + 112;
        return length;
    }

    public StnInfo getStnInfo() {
        return this.stnInfo;
    }

    public StnLocation getStnLocation() {
        return this.stnLocation;
    }

    public StnParameters getStnParameters() {
        return this.stnParameters;
    }

    public StnResponse getStnResponse() {
        return this.stnResponse;
    }

    public SeriesDatabase getSeriesDatabase() {
        return this.dbaSeries;
    }

    public StnDatabase getStnDatabase() {
        return this.dbaStation;
    }

    public SeriesInfo getSeriesInfo() {
        return this.seriesInfo;
    }
}

