/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class BasicFrame
extends JFrame {
    private boolean firstShowing = true;
    private Rectangle lastpos = new Rectangle(0, 0, 0, 0);

    public BasicFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloser());
        this.addComponentListener(new SizeHandler());
    }

    public BasicFrame(String string) {
        this();
        this.setTitle(string);
    }

    public void setVisible(boolean bl) {
        if (bl && this.firstShowing) {
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle2 = new Rectangle(dimension);
            int n = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
            int n2 = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
            this.setLocation(n, n2 / 2);
            this.lastpos.setBounds(this.getBounds());
        }
        super.setVisible(bl);
    }

    protected void handleResize() {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = this.getMinimumSize();
        boolean bl = false;
        if (rectangle.width < dimension.width) {
            if (rectangle.x != this.lastpos.x) {
                rectangle.x = this.lastpos.x + this.lastpos.width - dimension.width;
            }
            rectangle.width = dimension.width;
            bl = true;
        }
        if (rectangle.height < dimension.height) {
            if (rectangle.y != this.lastpos.y) {
                rectangle.y = this.lastpos.y + this.lastpos.height - dimension.height;
            }
            rectangle.height = dimension.height;
            bl = true;
        }
        if (bl) {
            this.setBounds(rectangle);
        }
        this.lastpos.setBounds(rectangle);
    }

    protected void closeWindow() {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    class SizeHandler
    extends ComponentAdapter {
        SizeHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BasicFrame.this.handleResize();
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            BasicFrame.this.closeWindow();
        }
    }
}

