/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.MsgClient;
import ca.nanometrics.msg.StatusMonitor;
import java.awt.Dimension;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConnectionController
extends ControlBar
implements ValueListener {
    private MsgClient client;
    private ConnectionSettings settings;
    private JLabel statusField;

    public ConnectionController(MsgClient msgClient, ConnectionSettings connectionSettings) {
        if (msgClient == null) {
            throw new IllegalArgumentException("null client in ConnectionController");
        }
        if (connectionSettings == null) {
            throw new IllegalArgumentException("null settings in ConnectionController");
        }
        this.client = msgClient;
        this.settings = connectionSettings;
        StringModelTextField stringModelTextField = new StringModelTextField(this.settings.getHostModel(), 15);
        Dimension dimension = stringModelTextField.getPreferredSize();
        dimension.width /= 2;
        stringModelTextField.setMinimumSize(dimension);
        this.addControl(new LabelledComponent(" host: ", (JComponent)stringModelTextField), false);
        IntegerModelTextField integerModelTextField = new IntegerModelTextField(this.settings.getPortModel(), 5);
        this.addControl(new LabelledComponent(" port: ", (JComponent)integerModelTextField), false);
        BooleanModelCheckBox booleanModelCheckBox = new BooleanModelCheckBox(" callback socket", this.settings.getCallbackModel());
        this.addLabelledControl("", booleanModelCheckBox, false);
        BooleanModelCheckBox booleanModelCheckBox2 = new BooleanModelCheckBox(" connect", this.settings.getConnectModel());
        this.addLabelledControl("", booleanModelCheckBox2, false);
        this.statusField = new JLabel("    ");
        this.addLabelledControl("", this.statusField, true);
        this.settings.getHostModel().addValueListener(this);
        this.settings.getPortModel().addValueListener(this);
        this.settings.getCallbackModel().addValueListener(this);
        this.settings.getConnectModel().addValueListener(this);
        this.client.setMonitor(new ClientMonitor());
    }

    public void valueChanged(Object object) {
        if (this.settings.isConnect()) {
            try {
                this.client.connectTo(this.settings.getHost(), this.settings.getPort(), this.settings.isCallback());
                this.statusField.setText("connecting");
            }
            catch (UnknownHostException unknownHostException) {
                this.statusField.setText("Unknown host");
                this.client.disconnect();
            }
        } else {
            this.client.disconnect();
            this.statusField.setText("disconnected");
        }
    }

    class ClientMonitor
    implements StatusMonitor {
        ClientMonitor() {
        }

        public void reportStatus(String string) {
            ConnectionController.this.statusField.setText(string);
        }
    }
}

