/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class DoubleModelTextField
extends JTextField
implements ValueListener {
    private DoubleModel model;

    public DoubleModelTextField(DoubleModel doubleModel) {
        this.model = doubleModel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in DoubleModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public DoubleModelTextField(DoubleModel doubleModel, int n) {
        this(doubleModel);
        this.setColumns(n);
    }

    public void valueChanged(Object object) {
        double d = this.model.getValue();
        super.setText(this.convertValueToText(d));
    }

    public void setValue(double d) {
        if (!this.model.setValue(d)) {
            this.valueChanged(this.model);
        }
    }

    public void setText(String string) {
        if (!this.model.setValue(string)) {
            this.valueChanged(this.model);
        }
    }

    public String convertValueToText(double d) {
        return "" + d;
    }

    public void update() {
        String string = this.getText();
        this.setText(string);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                DoubleModelTextField.this.update();
            }
            if (keyEvent.getKeyCode() == 27) {
                DoubleModelTextField.this.valueChanged(DoubleModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent focusEvent) {
            DoubleModelTextField.this.update();
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

