/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class IntegerModelTextField
extends JTextField
implements ValueListener {
    private IntegerModel model;
    private int columns;

    public IntegerModelTextField(IntegerModel integerModel) {
        this.model = integerModel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in IntegerModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public IntegerModelTextField(IntegerModel integerModel, int n) {
        this(integerModel);
        this.setColumns(n);
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    protected int charWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth("9");
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.columns > 0) {
            Insets insets = this.getInsets();
            dimension.width = insets.left + insets.right + this.columns * this.charWidth();
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.columns > 0) {
            Insets insets = this.getInsets();
            dimension.width = insets.left + insets.right + (this.columns + 1) * this.charWidth();
        }
        return dimension;
    }

    public void valueChanged(Object object) {
        int n = this.model.getValue();
        super.setText(this.convertValueToText(n));
    }

    public void setValue(int n) {
        if (!this.model.setValue(n)) {
            this.valueChanged(this.model);
        }
    }

    public void setText(String string) {
        if (!this.model.setValue(string)) {
            this.valueChanged(this.model);
        }
    }

    public String convertValueToText(int n) {
        return "" + n;
    }

    public void update() {
        String string = this.getText();
        this.setText(string);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                IntegerModelTextField.this.update();
            }
            if (keyEvent.getKeyCode() == 27) {
                IntegerModelTextField.this.valueChanged(IntegerModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent focusEvent) {
            IntegerModelTextField.this.update();
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

