/*
 * Decompiled with CFR 0.152.
 */
public class MovingAverage {
    private double average = 0.0;
    private double meanSquare = 0.0;
    private double decay = 1.0;

    public MovingAverage(double d) {
        this.setWidth(d);
    }

    public MovingAverage() {
        this(1.0);
    }

    public void setWidth(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        this.decay = 1.0 / d;
    }

    public void reset() {
        this.average = 0.0;
        this.meanSquare = 0.0;
    }

    public double getAverage() {
        return this.average;
    }

    public double getMeanSquare() {
        return this.meanSquare;
    }

    public double getRMS() {
        return Math.sqrt(this.meanSquare);
    }

    public void addSample(double d) {
        double d2 = d - this.average;
        this.average += this.decay * d2;
        this.meanSquare += this.decay * (d2 * d2 - this.meanSquare);
    }
}

