/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class MultiPanel
extends JPanel {
    private GridLayout layout = new GridLayout(1, 1);
    private String logoName;

    public MultiPanel(String string) {
        this.logoName = string;
        this.setLayout(this.layout);
        this.setFont(new Font("Dialog", 1, 48));
        this.setForeground(Color.blue);
    }

    protected void addPanel(JPanel jPanel) {
        if (jPanel != null && jPanel.getParent() != this) {
            if (jPanel.getName() == null) {
                jPanel.setName("");
            }
            String string = jPanel.getName();
            int n = 0;
            Component[] componentArray = this.getComponents();
            while (n < componentArray.length && string.compareTo(componentArray[n].getName()) > 0) {
                ++n;
            }
            if (n < componentArray.length) {
                this.add((Component)jPanel, n);
            } else {
                this.add(jPanel);
            }
            this.layout.setRows(this.getComponentCount());
            this.validate();
        }
    }

    protected void removePanel(JPanel jPanel) {
        if (jPanel != null && jPanel.getParent() == this) {
            this.remove(jPanel);
            int n = this.getComponentCount();
            if (n < 1) {
                n = 1;
            }
            this.layout.setRows(n);
            this.validate();
            this.repaint();
        }
    }

    protected void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.logoName != null && this.logoName.length() > 0) {
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 2;
            graphics.drawRect(n, n, this.getWidth() - 2 * n, this.getHeight() - 2 * n);
            n = 5;
            graphics.drawRect(n, n, this.getWidth() - 2 * n, this.getHeight() - 2 * n);
            int n2 = fontMetrics.stringWidth(this.logoName);
            int n3 = fontMetrics.getHeight();
            graphics.drawString(this.logoName, (this.getWidth() - n2) / 2, this.getHeight() / 2 + n3 / 4);
        }
    }
}

