/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

public class RulerPanel
extends JPanel {
    private double startSeconds;
    private double widthSeconds;
    private boolean inverted;
    private TicInfoTable ticTable = new TimeTicInfoTable();

    public RulerPanel() {
        this(0.0, 1.0, false);
    }

    public RulerPanel(boolean bl) {
        this(0.0, 1.0, bl);
    }

    public RulerPanel(double d, double d2, boolean bl) {
        this.startSeconds = d;
        this.widthSeconds = d2;
        this.inverted = bl;
        this.setFont(new Font("Dialog", 0, 10));
        this.setForeground(Color.black);
    }

    public void setStartSeconds(double d) {
        if (this.startSeconds != d) {
            this.startSeconds = d;
            this.repaint();
        }
    }

    public void setWidthSeconds(double d) {
        if (this.widthSeconds != d) {
            this.widthSeconds = d;
            this.repaint();
        }
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.repaint();
        }
    }

    public double getStartSeconds() {
        return this.startSeconds;
    }

    public double getWidthSeconds() {
        return this.widthSeconds;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void paint(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = n4;
        int n8 = n3 - n4;
        int n9 = fontMetrics.getHeight() * 3 / 5;
        if (this.inverted) {
            n = n7;
            n7 = n8;
            n8 = n;
            n9 = 0;
        }
        n = n7 - n8;
        int n10 = n6 - n5;
        graphics.drawLine(n5, n8, n6, n8);
        TicInfo ticInfo = this.ticTable.getTicInfo(this.widthSeconds);
        int n11 = 1;
        while (n11 <= 4) {
            double d = ticInfo.getTicInc(n11 - 1);
            if (!(d <= 0.0)) {
                double d2 = d * (double)n10 / this.widthSeconds;
                double d3 = Math.floor(this.startSeconds / d);
                double d4 = d3 * d;
                if (d4 < this.startSeconds) {
                    d4 += d;
                }
                double d5 = (double)n5 + (d4 - this.startSeconds) * (double)n10 / this.widthSeconds;
                int n12 = (int)(this.widthSeconds / d);
                int n13 = n8 + n * n11 / 4;
                int n14 = 0;
                while (n14 <= n12) {
                    int n15 = (int)(d5 + (double)n14 * d2 + 0.5);
                    graphics.drawLine(n15, n8, n15, n13);
                    if (n11 == 4) {
                        String string = ticInfo.getLabelOf(d4 + (double)n14 * d);
                        int n16 = fontMetrics.stringWidth(string);
                        graphics.drawString(string, n15 - 2 - n16, n13 + n9);
                    }
                    ++n14;
                }
            }
            ++n11;
        }
    }
}

