/*
 * Decompiled with CFR 0.152.
 */
public class SampleStatistics {
    private int sampleCount;
    private double sampleSum;
    private double squareSum;
    private int sampleMin;
    private int sampleMax;

    public SampleStatistics() {
        this.reset();
    }

    public void reset() {
        this.sampleCount = 0;
        this.sampleSum = 0.0;
        this.squareSum = 0.0;
        this.sampleMin = Integer.MAX_VALUE;
        this.sampleMax = Integer.MIN_VALUE;
    }

    public void addSample(int n) {
        ++this.sampleCount;
        this.sampleSum += (double)n;
        this.squareSum += (double)n * (double)n;
        if (this.sampleMin > n) {
            this.sampleMin = n;
        }
        if (this.sampleMax < n) {
            this.sampleMax = n;
        }
    }

    public void addSample(SampleStatistics sampleStatistics) {
        this.sampleCount += sampleStatistics.getSampleCount();
        this.sampleSum += sampleStatistics.getSampleSum();
        this.squareSum += sampleStatistics.getSquareSum();
        if (this.sampleMin > sampleStatistics.getMin()) {
            this.sampleMin = sampleStatistics.getMin();
        }
        if (this.sampleMax < sampleStatistics.getMax()) {
            this.sampleMax = sampleStatistics.getMax();
        }
    }

    public void copy(SampleStatistics sampleStatistics) {
        this.sampleCount = sampleStatistics.getSampleCount();
        this.sampleSum = sampleStatistics.getSampleSum();
        this.squareSum = sampleStatistics.getSquareSum();
        this.sampleMin = sampleStatistics.getMin();
        this.sampleMax = sampleStatistics.getMax();
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public double getSampleSum() {
        return this.sampleSum;
    }

    public double getSquareSum() {
        return this.squareSum;
    }

    public int getMin() {
        return this.sampleMin;
    }

    public int getMax() {
        return this.sampleMax;
    }

    public double getAverage() {
        if (this.sampleCount > 0) {
            return this.sampleSum / (double)this.sampleCount;
        }
        return 0.0;
    }

    public double getRMS() {
        if (this.sampleCount > 0) {
            double d = this.getAverage();
            double d2 = this.squareSum / (double)this.sampleCount - d * d;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            return Math.sqrt(d2);
        }
        return 0.0;
    }

    public void show(String string) {
        System.out.println("SampleStatistics " + string);
        System.out.println("Count  " + this.getSampleCount());
        System.out.println("Sum    " + this.getSampleSum());
        System.out.println("SumSqr " + this.getSquareSum());
        System.out.println("Max    " + this.getMax());
        System.out.println("Min    " + this.getMin());
        System.out.println("Avg    " + this.getAverage());
        System.out.println("RMS    " + this.getRMS());
    }
}

