/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SettingsManager {
    private Frame parent;
    private Settings savedSettings;
    private Settings settings;
    private FileDialog openFileDialog;
    private FileDialog saveFileDialog;

    public SettingsManager(Settings settings, Frame frame) {
        this.settings = settings;
        this.savedSettings = this.settings.copy();
        this.parent = frame;
        this.initFileDialogs();
    }

    protected void initFileDialogs() {
        this.openFileDialog = new FileDialog(this.parent);
        this.openFileDialog.setMode(0);
        this.openFileDialog.setTitle("Open");
        this.saveFileDialog = new FileDialog(this.parent);
        this.saveFileDialog.setMode(1);
        this.saveFileDialog.setTitle("Save As");
    }

    protected File getOpenFileName() {
        String string = this.openFileDialog.getDirectory();
        String string2 = this.openFileDialog.getFile();
        this.openFileDialog.setVisible(true);
        String string3 = this.openFileDialog.getFile();
        if (string3 == null) {
            this.openFileDialog.setDirectory(string);
            this.openFileDialog.setFile(string2);
            return null;
        }
        return new File(this.openFileDialog.getDirectory(), string3);
    }

    protected File getSaveFileName() {
        String string = this.saveFileDialog.getDirectory();
        String string2 = this.saveFileDialog.getFile();
        if (this.settings.getFile() != null) {
            this.saveFileDialog.setFile(this.settings.getFile().getName());
        }
        this.saveFileDialog.setVisible(true);
        String string3 = this.saveFileDialog.getFile();
        String string4 = this.saveFileDialog.getDirectory();
        if (string3 == null) {
            this.saveFileDialog.setDirectory(string);
            this.saveFileDialog.setFile(string2);
            return null;
        }
        return new File(string4, string3);
    }

    void saveSettings(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.settings.save(fileOutputStream);
            this.settings.setFile(file);
            this.savedSettings = this.settings.copy();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, "Unable to save settings to file:\n" + file.getAbsolutePath() + "\n\n" + iOException.getMessage(), "Save Settings", 2);
        }
    }

    protected void loadSettings(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.parent, "Cannot find settings file:\n" + file.getAbsolutePath(), "Open Settings", 2);
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Settings settings = this.settings.load(fileInputStream);
            this.settings.applySettings(settings);
            this.settings.setFile(file);
            this.savedSettings = this.settings.copy();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, "Unable to load settings from file:\n" + file.getAbsolutePath() + "\n\n" + iOException.getMessage(), "Load Settings", 2);
        }
    }

    boolean okToLoseSettings() {
        if (!this.settings.equals(this.savedSettings)) {
            SaveDialog saveDialog = new SaveDialog(this.parent);
            if (this.settings.getFile() != null) {
                saveDialog.setFile(this.settings.getFile().getName());
            }
            saveDialog.setVisible(true);
            if (saveDialog.getResult() == 2) {
                this.doSaveAction();
                return this.settings.equals(this.savedSettings);
            }
            return saveDialog.getResult() == 1;
        }
        return true;
    }

    protected void doLoadAction() {
        File file;
        if (this.okToLoseSettings() && (file = this.getOpenFileName()) != null) {
            this.loadSettings(file);
        }
    }

    protected void doSaveAction() {
        if (this.settings.getFile() == null) {
            this.doSaveAsAction();
        } else {
            this.saveSettings(this.settings.getFile());
        }
    }

    protected void doSaveAsAction() {
        File file = this.getSaveFileName();
        if (file != null) {
            this.saveSettings(file);
        }
    }
}

