/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class StringModelTextField
extends JTextField
implements ValueListener {
    private StringModel model;

    public StringModelTextField(StringModel stringModel) {
        this.model = stringModel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in StringModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public StringModelTextField(StringModel stringModel, int n) {
        this(stringModel);
        this.setColumns(n);
    }

    public void valueChanged(Object object) {
        super.setText(this.model.getValue());
    }

    public void setText(String string) {
        if (!this.model.setValue(string)) {
            this.valueChanged(this.model);
        }
    }

    public void update() {
        String string = this.getText();
        this.setText(string);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                StringModelTextField.this.update();
            }
            if (keyEvent.getKeyCode() == 27) {
                StringModelTextField.this.valueChanged(StringModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent focusEvent) {
            StringModelTextField.this.update();
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

